/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.ListAccessPointsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListAccessPointsRequestMarshaller
implements Marshaller<Request<ListAccessPointsRequest>, ListAccessPointsRequest> {
    public Request<ListAccessPointsRequest> marshall(ListAccessPointsRequest listAccessPointsRequest) {
        if (listAccessPointsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAccessPointsRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (listAccessPointsRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)listAccessPointsRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accesspoint";
        request.setResourcePath(uriResourcePath);
        if (listAccessPointsRequest.getBucket() != null) {
            request.addParameter("bucket", StringUtils.fromString((String)listAccessPointsRequest.getBucket()));
        }
        if (listAccessPointsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listAccessPointsRequest.getNextToken()));
        }
        if (listAccessPointsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listAccessPointsRequest.getMaxResults()));
        }
        return request;
    }
}

