/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListOptimizationJobs" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListOptimizationJobsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of optimization jobs and their properties that matches any of the filters you specified in the request.
     * </p>
     */
    private java.util.List<OptimizationJobSummary> optimizationJobSummaries;
    /**
     * <p>
     * The token to use in a subsequent request to get the next set of results following a truncated response.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of optimization jobs and their properties that matches any of the filters you specified in the request.
     * </p>
     * 
     * @return A list of optimization jobs and their properties that matches any of the filters you specified in the
     *         request.
     */

    public java.util.List<OptimizationJobSummary> getOptimizationJobSummaries() {
        return optimizationJobSummaries;
    }

    /**
     * <p>
     * A list of optimization jobs and their properties that matches any of the filters you specified in the request.
     * </p>
     * 
     * @param optimizationJobSummaries
     *        A list of optimization jobs and their properties that matches any of the filters you specified in the
     *        request.
     */

    public void setOptimizationJobSummaries(java.util.Collection<OptimizationJobSummary> optimizationJobSummaries) {
        if (optimizationJobSummaries == null) {
            this.optimizationJobSummaries = null;
            return;
        }

        this.optimizationJobSummaries = new java.util.ArrayList<OptimizationJobSummary>(optimizationJobSummaries);
    }

    /**
     * <p>
     * A list of optimization jobs and their properties that matches any of the filters you specified in the request.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setOptimizationJobSummaries(java.util.Collection)} or
     * {@link #withOptimizationJobSummaries(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param optimizationJobSummaries
     *        A list of optimization jobs and their properties that matches any of the filters you specified in the
     *        request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListOptimizationJobsResult withOptimizationJobSummaries(OptimizationJobSummary... optimizationJobSummaries) {
        if (this.optimizationJobSummaries == null) {
            setOptimizationJobSummaries(new java.util.ArrayList<OptimizationJobSummary>(optimizationJobSummaries.length));
        }
        for (OptimizationJobSummary ele : optimizationJobSummaries) {
            this.optimizationJobSummaries.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of optimization jobs and their properties that matches any of the filters you specified in the request.
     * </p>
     * 
     * @param optimizationJobSummaries
     *        A list of optimization jobs and their properties that matches any of the filters you specified in the
     *        request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListOptimizationJobsResult withOptimizationJobSummaries(java.util.Collection<OptimizationJobSummary> optimizationJobSummaries) {
        setOptimizationJobSummaries(optimizationJobSummaries);
        return this;
    }

    /**
     * <p>
     * The token to use in a subsequent request to get the next set of results following a truncated response.
     * </p>
     * 
     * @param nextToken
     *        The token to use in a subsequent request to get the next set of results following a truncated response.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token to use in a subsequent request to get the next set of results following a truncated response.
     * </p>
     * 
     * @return The token to use in a subsequent request to get the next set of results following a truncated response.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token to use in a subsequent request to get the next set of results following a truncated response.
     * </p>
     * 
     * @param nextToken
     *        The token to use in a subsequent request to get the next set of results following a truncated response.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListOptimizationJobsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOptimizationJobSummaries() != null)
            sb.append("OptimizationJobSummaries: ").append(getOptimizationJobSummaries()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListOptimizationJobsResult == false)
            return false;
        ListOptimizationJobsResult other = (ListOptimizationJobsResult) obj;
        if (other.getOptimizationJobSummaries() == null ^ this.getOptimizationJobSummaries() == null)
            return false;
        if (other.getOptimizationJobSummaries() != null && other.getOptimizationJobSummaries().equals(this.getOptimizationJobSummaries()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOptimizationJobSummaries() == null) ? 0 : getOptimizationJobSummaries().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListOptimizationJobsResult clone() {
        try {
            return (ListOptimizationJobsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
