/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sagemaker.model.ContainerDefinition;
import com.amazonaws.services.sagemaker.model.DeploymentRecommendation;
import com.amazonaws.services.sagemaker.model.InferenceExecutionConfig;
import com.amazonaws.services.sagemaker.model.VpcConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DescribeModelResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String modelName;
    private ContainerDefinition primaryContainer;
    private List<ContainerDefinition> containers;
    private InferenceExecutionConfig inferenceExecutionConfig;
    private String executionRoleArn;
    private VpcConfig vpcConfig;
    private Date creationTime;
    private String modelArn;
    private Boolean enableNetworkIsolation;
    private DeploymentRecommendation deploymentRecommendation;

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public DescribeModelResult withModelName(String modelName) {
        this.setModelName(modelName);
        return this;
    }

    public void setPrimaryContainer(ContainerDefinition primaryContainer) {
        this.primaryContainer = primaryContainer;
    }

    public ContainerDefinition getPrimaryContainer() {
        return this.primaryContainer;
    }

    public DescribeModelResult withPrimaryContainer(ContainerDefinition primaryContainer) {
        this.setPrimaryContainer(primaryContainer);
        return this;
    }

    public List<ContainerDefinition> getContainers() {
        return this.containers;
    }

    public void setContainers(Collection<ContainerDefinition> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new ArrayList<ContainerDefinition>(containers);
    }

    public DescribeModelResult withContainers(ContainerDefinition ... containers) {
        if (this.containers == null) {
            this.setContainers(new ArrayList<ContainerDefinition>(containers.length));
        }
        for (ContainerDefinition ele : containers) {
            this.containers.add(ele);
        }
        return this;
    }

    public DescribeModelResult withContainers(Collection<ContainerDefinition> containers) {
        this.setContainers(containers);
        return this;
    }

    public void setInferenceExecutionConfig(InferenceExecutionConfig inferenceExecutionConfig) {
        this.inferenceExecutionConfig = inferenceExecutionConfig;
    }

    public InferenceExecutionConfig getInferenceExecutionConfig() {
        return this.inferenceExecutionConfig;
    }

    public DescribeModelResult withInferenceExecutionConfig(InferenceExecutionConfig inferenceExecutionConfig) {
        this.setInferenceExecutionConfig(inferenceExecutionConfig);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public DescribeModelResult withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public DescribeModelResult withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public DescribeModelResult withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setModelArn(String modelArn) {
        this.modelArn = modelArn;
    }

    public String getModelArn() {
        return this.modelArn;
    }

    public DescribeModelResult withModelArn(String modelArn) {
        this.setModelArn(modelArn);
        return this;
    }

    public void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.enableNetworkIsolation = enableNetworkIsolation;
    }

    public Boolean getEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public DescribeModelResult withEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.setEnableNetworkIsolation(enableNetworkIsolation);
        return this;
    }

    public Boolean isEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public void setDeploymentRecommendation(DeploymentRecommendation deploymentRecommendation) {
        this.deploymentRecommendation = deploymentRecommendation;
    }

    public DeploymentRecommendation getDeploymentRecommendation() {
        return this.deploymentRecommendation;
    }

    public DescribeModelResult withDeploymentRecommendation(DeploymentRecommendation deploymentRecommendation) {
        this.setDeploymentRecommendation(deploymentRecommendation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelName() != null) {
            sb.append("ModelName: ").append(this.getModelName()).append(",");
        }
        if (this.getPrimaryContainer() != null) {
            sb.append("PrimaryContainer: ").append(this.getPrimaryContainer()).append(",");
        }
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getInferenceExecutionConfig() != null) {
            sb.append("InferenceExecutionConfig: ").append(this.getInferenceExecutionConfig()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getModelArn() != null) {
            sb.append("ModelArn: ").append(this.getModelArn()).append(",");
        }
        if (this.getEnableNetworkIsolation() != null) {
            sb.append("EnableNetworkIsolation: ").append(this.getEnableNetworkIsolation()).append(",");
        }
        if (this.getDeploymentRecommendation() != null) {
            sb.append("DeploymentRecommendation: ").append(this.getDeploymentRecommendation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelResult)) {
            return false;
        }
        DescribeModelResult other = (DescribeModelResult)obj;
        if (other.getModelName() == null ^ this.getModelName() == null) {
            return false;
        }
        if (other.getModelName() != null && !other.getModelName().equals(this.getModelName())) {
            return false;
        }
        if (other.getPrimaryContainer() == null ^ this.getPrimaryContainer() == null) {
            return false;
        }
        if (other.getPrimaryContainer() != null && !other.getPrimaryContainer().equals(this.getPrimaryContainer())) {
            return false;
        }
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getInferenceExecutionConfig() == null ^ this.getInferenceExecutionConfig() == null) {
            return false;
        }
        if (other.getInferenceExecutionConfig() != null && !other.getInferenceExecutionConfig().equals(this.getInferenceExecutionConfig())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getModelArn() == null ^ this.getModelArn() == null) {
            return false;
        }
        if (other.getModelArn() != null && !other.getModelArn().equals(this.getModelArn())) {
            return false;
        }
        if (other.getEnableNetworkIsolation() == null ^ this.getEnableNetworkIsolation() == null) {
            return false;
        }
        if (other.getEnableNetworkIsolation() != null && !other.getEnableNetworkIsolation().equals(this.getEnableNetworkIsolation())) {
            return false;
        }
        if (other.getDeploymentRecommendation() == null ^ this.getDeploymentRecommendation() == null) {
            return false;
        }
        return other.getDeploymentRecommendation() == null || other.getDeploymentRecommendation().equals(this.getDeploymentRecommendation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelName() == null ? 0 : this.getModelName().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryContainer() == null ? 0 : this.getPrimaryContainer().hashCode());
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceExecutionConfig() == null ? 0 : this.getInferenceExecutionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getModelArn() == null ? 0 : this.getModelArn().hashCode());
        hashCode = 31 * hashCode + (this.getEnableNetworkIsolation() == null ? 0 : this.getEnableNetworkIsolation().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentRecommendation() == null ? 0 : this.getDeploymentRecommendation().hashCode());
        return hashCode;
    }

    public DescribeModelResult clone() {
        try {
            return (DescribeModelResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

