/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.EnvironmentParameter;
import com.amazonaws.services.sagemaker.model.transform.ModelConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModelConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String inferenceSpecificationName;
    private List<EnvironmentParameter> environmentParameters;
    private String compilationJobName;

    public void setInferenceSpecificationName(String inferenceSpecificationName) {
        this.inferenceSpecificationName = inferenceSpecificationName;
    }

    public String getInferenceSpecificationName() {
        return this.inferenceSpecificationName;
    }

    public ModelConfiguration withInferenceSpecificationName(String inferenceSpecificationName) {
        this.setInferenceSpecificationName(inferenceSpecificationName);
        return this;
    }

    public List<EnvironmentParameter> getEnvironmentParameters() {
        return this.environmentParameters;
    }

    public void setEnvironmentParameters(Collection<EnvironmentParameter> environmentParameters) {
        if (environmentParameters == null) {
            this.environmentParameters = null;
            return;
        }
        this.environmentParameters = new ArrayList<EnvironmentParameter>(environmentParameters);
    }

    public ModelConfiguration withEnvironmentParameters(EnvironmentParameter ... environmentParameters) {
        if (this.environmentParameters == null) {
            this.setEnvironmentParameters(new ArrayList<EnvironmentParameter>(environmentParameters.length));
        }
        for (EnvironmentParameter ele : environmentParameters) {
            this.environmentParameters.add(ele);
        }
        return this;
    }

    public ModelConfiguration withEnvironmentParameters(Collection<EnvironmentParameter> environmentParameters) {
        this.setEnvironmentParameters(environmentParameters);
        return this;
    }

    public void setCompilationJobName(String compilationJobName) {
        this.compilationJobName = compilationJobName;
    }

    public String getCompilationJobName() {
        return this.compilationJobName;
    }

    public ModelConfiguration withCompilationJobName(String compilationJobName) {
        this.setCompilationJobName(compilationJobName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInferenceSpecificationName() != null) {
            sb.append("InferenceSpecificationName: ").append(this.getInferenceSpecificationName()).append(",");
        }
        if (this.getEnvironmentParameters() != null) {
            sb.append("EnvironmentParameters: ").append(this.getEnvironmentParameters()).append(",");
        }
        if (this.getCompilationJobName() != null) {
            sb.append("CompilationJobName: ").append(this.getCompilationJobName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelConfiguration)) {
            return false;
        }
        ModelConfiguration other = (ModelConfiguration)obj;
        if (other.getInferenceSpecificationName() == null ^ this.getInferenceSpecificationName() == null) {
            return false;
        }
        if (other.getInferenceSpecificationName() != null && !other.getInferenceSpecificationName().equals(this.getInferenceSpecificationName())) {
            return false;
        }
        if (other.getEnvironmentParameters() == null ^ this.getEnvironmentParameters() == null) {
            return false;
        }
        if (other.getEnvironmentParameters() != null && !other.getEnvironmentParameters().equals(this.getEnvironmentParameters())) {
            return false;
        }
        if (other.getCompilationJobName() == null ^ this.getCompilationJobName() == null) {
            return false;
        }
        return other.getCompilationJobName() == null || other.getCompilationJobName().equals(this.getCompilationJobName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInferenceSpecificationName() == null ? 0 : this.getInferenceSpecificationName().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentParameters() == null ? 0 : this.getEnvironmentParameters().hashCode());
        hashCode = 31 * hashCode + (this.getCompilationJobName() == null ? 0 : this.getCompilationJobName().hashCode());
        return hashCode;
    }

    public ModelConfiguration clone() {
        try {
            return (ModelConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ModelConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

