/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AlgorithmSpecification;
import java.util.List;

@SdkInternalApi
public class AlgorithmSpecificationMarshaller {
    private static final MarshallingInfo<String> TRAININGIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingImage").build();
    private static final MarshallingInfo<String> ALGORITHMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlgorithmName").build();
    private static final MarshallingInfo<String> TRAININGINPUTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingInputMode").build();
    private static final MarshallingInfo<List> METRICDEFINITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricDefinitions").build();
    private static final MarshallingInfo<Boolean> ENABLESAGEMAKERMETRICSTIMESERIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableSageMakerMetricsTimeSeries").build();
    private static final MarshallingInfo<List> CONTAINERENTRYPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainerEntrypoint").build();
    private static final MarshallingInfo<List> CONTAINERARGUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainerArguments").build();
    private static final MarshallingInfo<StructuredPojo> TRAININGIMAGECONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingImageConfig").build();
    private static final AlgorithmSpecificationMarshaller instance = new AlgorithmSpecificationMarshaller();

    public static AlgorithmSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AlgorithmSpecification algorithmSpecification, ProtocolMarshaller protocolMarshaller) {
        if (algorithmSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)algorithmSpecification.getTrainingImage(), TRAININGIMAGE_BINDING);
            protocolMarshaller.marshall((Object)algorithmSpecification.getAlgorithmName(), ALGORITHMNAME_BINDING);
            protocolMarshaller.marshall((Object)algorithmSpecification.getTrainingInputMode(), TRAININGINPUTMODE_BINDING);
            protocolMarshaller.marshall(algorithmSpecification.getMetricDefinitions(), METRICDEFINITIONS_BINDING);
            protocolMarshaller.marshall((Object)algorithmSpecification.getEnableSageMakerMetricsTimeSeries(), ENABLESAGEMAKERMETRICSTIMESERIES_BINDING);
            protocolMarshaller.marshall(algorithmSpecification.getContainerEntrypoint(), CONTAINERENTRYPOINT_BINDING);
            protocolMarshaller.marshall(algorithmSpecification.getContainerArguments(), CONTAINERARGUMENTS_BINDING);
            protocolMarshaller.marshall((Object)algorithmSpecification.getTrainingImageConfig(), TRAININGIMAGECONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

