/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemakermetrics.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The raw metric data to associate with the resource.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-metrics-2022-09-30/RawMetricData" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RawMetricData implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the metric.
     * </p>
     */
    private String metricName;
    /**
     * <p>
     * The time that the metric was recorded.
     * </p>
     */
    private java.util.Date timestamp;
    /**
     * <p>
     * The metric step (epoch).
     * </p>
     */
    private Integer step;
    /**
     * <p>
     * The metric value.
     * </p>
     */
    private Double value;

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @param metricName
     *        The name of the metric.
     */

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */

    public String getMetricName() {
        return this.metricName;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @param metricName
     *        The name of the metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RawMetricData withMetricName(String metricName) {
        setMetricName(metricName);
        return this;
    }

    /**
     * <p>
     * The time that the metric was recorded.
     * </p>
     * 
     * @param timestamp
     *        The time that the metric was recorded.
     */

    public void setTimestamp(java.util.Date timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * <p>
     * The time that the metric was recorded.
     * </p>
     * 
     * @return The time that the metric was recorded.
     */

    public java.util.Date getTimestamp() {
        return this.timestamp;
    }

    /**
     * <p>
     * The time that the metric was recorded.
     * </p>
     * 
     * @param timestamp
     *        The time that the metric was recorded.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RawMetricData withTimestamp(java.util.Date timestamp) {
        setTimestamp(timestamp);
        return this;
    }

    /**
     * <p>
     * The metric step (epoch).
     * </p>
     * 
     * @param step
     *        The metric step (epoch).
     */

    public void setStep(Integer step) {
        this.step = step;
    }

    /**
     * <p>
     * The metric step (epoch).
     * </p>
     * 
     * @return The metric step (epoch).
     */

    public Integer getStep() {
        return this.step;
    }

    /**
     * <p>
     * The metric step (epoch).
     * </p>
     * 
     * @param step
     *        The metric step (epoch).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RawMetricData withStep(Integer step) {
        setStep(step);
        return this;
    }

    /**
     * <p>
     * The metric value.
     * </p>
     * 
     * @param value
     *        The metric value.
     */

    public void setValue(Double value) {
        this.value = value;
    }

    /**
     * <p>
     * The metric value.
     * </p>
     * 
     * @return The metric value.
     */

    public Double getValue() {
        return this.value;
    }

    /**
     * <p>
     * The metric value.
     * </p>
     * 
     * @param value
     *        The metric value.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RawMetricData withValue(Double value) {
        setValue(value);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMetricName() != null)
            sb.append("MetricName: ").append(getMetricName()).append(",");
        if (getTimestamp() != null)
            sb.append("Timestamp: ").append(getTimestamp()).append(",");
        if (getStep() != null)
            sb.append("Step: ").append(getStep()).append(",");
        if (getValue() != null)
            sb.append("Value: ").append(getValue());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RawMetricData == false)
            return false;
        RawMetricData other = (RawMetricData) obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null)
            return false;
        if (other.getMetricName() != null && other.getMetricName().equals(this.getMetricName()) == false)
            return false;
        if (other.getTimestamp() == null ^ this.getTimestamp() == null)
            return false;
        if (other.getTimestamp() != null && other.getTimestamp().equals(this.getTimestamp()) == false)
            return false;
        if (other.getStep() == null ^ this.getStep() == null)
            return false;
        if (other.getStep() != null && other.getStep().equals(this.getStep()) == false)
            return false;
        if (other.getValue() == null ^ this.getValue() == null)
            return false;
        if (other.getValue() != null && other.getValue().equals(this.getValue()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMetricName() == null) ? 0 : getMetricName().hashCode());
        hashCode = prime * hashCode + ((getTimestamp() == null) ? 0 : getTimestamp().hashCode());
        hashCode = prime * hashCode + ((getStep() == null) ? 0 : getStep().hashCode());
        hashCode = prime * hashCode + ((getValue() == null) ? 0 : getValue().hashCode());
        return hashCode;
    }

    @Override
    public RawMetricData clone() {
        try {
            return (RawMetricData) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemakermetrics.model.transform.RawMetricDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
