/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.securityhub.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AwsSnsTopicDetailsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AwsSnsTopicDetailsMarshaller {

    private static final MarshallingInfo<String> KMSMASTERKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsMasterKeyId").build();
    private static final MarshallingInfo<List> SUBSCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Subscription").build();
    private static final MarshallingInfo<String> TOPICNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("TopicName").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Owner").build();
    private static final MarshallingInfo<String> SQSSUCCESSFEEDBACKROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqsSuccessFeedbackRoleArn").build();
    private static final MarshallingInfo<String> SQSFAILUREFEEDBACKROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SqsFailureFeedbackRoleArn").build();
    private static final MarshallingInfo<String> APPLICATIONSUCCESSFEEDBACKROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationSuccessFeedbackRoleArn").build();
    private static final MarshallingInfo<String> FIREHOSESUCCESSFEEDBACKROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirehoseSuccessFeedbackRoleArn").build();
    private static final MarshallingInfo<String> FIREHOSEFAILUREFEEDBACKROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirehoseFailureFeedbackRoleArn").build();
    private static final MarshallingInfo<String> HTTPSUCCESSFEEDBACKROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpSuccessFeedbackRoleArn").build();
    private static final MarshallingInfo<String> HTTPFAILUREFEEDBACKROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HttpFailureFeedbackRoleArn").build();

    private static final AwsSnsTopicDetailsMarshaller instance = new AwsSnsTopicDetailsMarshaller();

    public static AwsSnsTopicDetailsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AwsSnsTopicDetails awsSnsTopicDetails, ProtocolMarshaller protocolMarshaller) {

        if (awsSnsTopicDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(awsSnsTopicDetails.getKmsMasterKeyId(), KMSMASTERKEYID_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getSubscription(), SUBSCRIPTION_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getTopicName(), TOPICNAME_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getOwner(), OWNER_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getSqsSuccessFeedbackRoleArn(), SQSSUCCESSFEEDBACKROLEARN_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getSqsFailureFeedbackRoleArn(), SQSFAILUREFEEDBACKROLEARN_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getApplicationSuccessFeedbackRoleArn(), APPLICATIONSUCCESSFEEDBACKROLEARN_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getFirehoseSuccessFeedbackRoleArn(), FIREHOSESUCCESSFEEDBACKROLEARN_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getFirehoseFailureFeedbackRoleArn(), FIREHOSEFAILUREFEEDBACKROLEARN_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getHttpSuccessFeedbackRoleArn(), HTTPSUCCESSFEEDBACKROLEARN_BINDING);
            protocolMarshaller.marshall(awsSnsTopicDetails.getHttpFailureFeedbackRoleArn(), HTTPFAILUREFEEDBACKROLEARN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
