/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.securityhub.model.Member;
import com.amazonaws.services.securityhub.model.Result;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetMembersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Member> members;
    private List<Result> unprocessedAccounts;

    public List<Member> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<Member> members) {
        if (members == null) {
            this.members = null;
            return;
        }
        this.members = new ArrayList<Member>(members);
    }

    public GetMembersResult withMembers(Member ... members) {
        if (this.members == null) {
            this.setMembers(new ArrayList<Member>(members.length));
        }
        for (Member ele : members) {
            this.members.add(ele);
        }
        return this;
    }

    public GetMembersResult withMembers(Collection<Member> members) {
        this.setMembers(members);
        return this;
    }

    public List<Result> getUnprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public void setUnprocessedAccounts(Collection<Result> unprocessedAccounts) {
        if (unprocessedAccounts == null) {
            this.unprocessedAccounts = null;
            return;
        }
        this.unprocessedAccounts = new ArrayList<Result>(unprocessedAccounts);
    }

    public GetMembersResult withUnprocessedAccounts(Result ... unprocessedAccounts) {
        if (this.unprocessedAccounts == null) {
            this.setUnprocessedAccounts(new ArrayList<Result>(unprocessedAccounts.length));
        }
        for (Result ele : unprocessedAccounts) {
            this.unprocessedAccounts.add(ele);
        }
        return this;
    }

    public GetMembersResult withUnprocessedAccounts(Collection<Result> unprocessedAccounts) {
        this.setUnprocessedAccounts(unprocessedAccounts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMembers() != null) {
            sb.append("Members: ").append(this.getMembers()).append(",");
        }
        if (this.getUnprocessedAccounts() != null) {
            sb.append("UnprocessedAccounts: ").append(this.getUnprocessedAccounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMembersResult)) {
            return false;
        }
        GetMembersResult other = (GetMembersResult)obj;
        if (other.getMembers() == null ^ this.getMembers() == null) {
            return false;
        }
        if (other.getMembers() != null && !other.getMembers().equals(this.getMembers())) {
            return false;
        }
        if (other.getUnprocessedAccounts() == null ^ this.getUnprocessedAccounts() == null) {
            return false;
        }
        return other.getUnprocessedAccounts() == null || other.getUnprocessedAccounts().equals(this.getUnprocessedAccounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMembers() == null ? 0 : this.getMembers().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedAccounts() == null ? 0 : this.getUnprocessedAccounts().hashCode());
        return hashCode;
    }

    public GetMembersResult clone() {
        try {
            return (GetMembersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

