/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.ParameterConfiguration;
import com.amazonaws.services.securityhub.model.transform.SecurityControlCustomParameterMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SecurityControlCustomParameter
implements Serializable,
Cloneable,
StructuredPojo {
    private String securityControlId;
    private Map<String, ParameterConfiguration> parameters;

    public void setSecurityControlId(String securityControlId) {
        this.securityControlId = securityControlId;
    }

    public String getSecurityControlId() {
        return this.securityControlId;
    }

    public SecurityControlCustomParameter withSecurityControlId(String securityControlId) {
        this.setSecurityControlId(securityControlId);
        return this;
    }

    public Map<String, ParameterConfiguration> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, ParameterConfiguration> parameters) {
        this.parameters = parameters;
    }

    public SecurityControlCustomParameter withParameters(Map<String, ParameterConfiguration> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public SecurityControlCustomParameter addParametersEntry(String key, ParameterConfiguration value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, ParameterConfiguration>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public SecurityControlCustomParameter clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityControlId() != null) {
            sb.append("SecurityControlId: ").append(this.getSecurityControlId()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityControlCustomParameter)) {
            return false;
        }
        SecurityControlCustomParameter other = (SecurityControlCustomParameter)obj;
        if (other.getSecurityControlId() == null ^ this.getSecurityControlId() == null) {
            return false;
        }
        if (other.getSecurityControlId() != null && !other.getSecurityControlId().equals(this.getSecurityControlId())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityControlId() == null ? 0 : this.getSecurityControlId().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public SecurityControlCustomParameter clone() {
        try {
            return (SecurityControlCustomParameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityControlCustomParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

