/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.servicecatalog.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about the organization node.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/OrganizationNode" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OrganizationNode implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The organization node type.
     * </p>
     */
    private String type;
    /**
     * <p>
     * The identifier of the organization node.
     * </p>
     */
    private String value;

    /**
     * <p>
     * The organization node type.
     * </p>
     * 
     * @param type
     *        The organization node type.
     * @see OrganizationNodeType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The organization node type.
     * </p>
     * 
     * @return The organization node type.
     * @see OrganizationNodeType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The organization node type.
     * </p>
     * 
     * @param type
     *        The organization node type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OrganizationNodeType
     */

    public OrganizationNode withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The organization node type.
     * </p>
     * 
     * @param type
     *        The organization node type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OrganizationNodeType
     */

    public OrganizationNode withType(OrganizationNodeType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * The identifier of the organization node.
     * </p>
     * 
     * @param value
     *        The identifier of the organization node.
     */

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * <p>
     * The identifier of the organization node.
     * </p>
     * 
     * @return The identifier of the organization node.
     */

    public String getValue() {
        return this.value;
    }

    /**
     * <p>
     * The identifier of the organization node.
     * </p>
     * 
     * @param value
     *        The identifier of the organization node.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OrganizationNode withValue(String value) {
        setValue(value);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getValue() != null)
            sb.append("Value: ").append(getValue());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OrganizationNode == false)
            return false;
        OrganizationNode other = (OrganizationNode) obj;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getValue() == null ^ this.getValue() == null)
            return false;
        if (other.getValue() != null && other.getValue().equals(this.getValue()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getValue() == null) ? 0 : getValue().hashCode());
        return hashCode;
    }

    @Override
    public OrganizationNode clone() {
        try {
            return (OrganizationNode) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.servicecatalog.model.transform.OrganizationNodeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
