/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.MessageTag;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.nio.ByteBuffer;

public class SendRawEmailRequestMarshaller
implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {
    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {
        SdkInternalList tagsList;
        RawMessage rawMessage;
        SdkInternalList destinationsList;
        if (sendRawEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendRawEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendRawEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendRawEmailRequest.getSource()));
        }
        if (!(destinationsList = (SdkInternalList)sendRawEmailRequest.getDestinations()).isEmpty() || !destinationsList.isAutoConstruct()) {
            int destinationsListIndex = 1;
            for (String destinationsListValue : destinationsList) {
                if (destinationsListValue != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex, StringUtils.fromString((String)destinationsListValue));
                }
                ++destinationsListIndex;
            }
        }
        if ((rawMessage = sendRawEmailRequest.getRawMessage()) != null && rawMessage.getData() != null) {
            request.addParameter("RawMessage.Data", StringUtils.fromByteBuffer((ByteBuffer)rawMessage.getData()));
        }
        if (sendRawEmailRequest.getFromArn() != null) {
            request.addParameter("FromArn", StringUtils.fromString((String)sendRawEmailRequest.getFromArn()));
        }
        if (sendRawEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendRawEmailRequest.getSourceArn()));
        }
        if (sendRawEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendRawEmailRequest.getReturnPathArn()));
        }
        if (!(tagsList = (SdkInternalList)sendRawEmailRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue.getName() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString((String)tagsListValue.getName()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (sendRawEmailRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)sendRawEmailRequest.getConfigurationSetName()));
        }
        return request;
    }
}

