/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.Destination;
import com.amazonaws.services.simpleemailv2.model.MessageTag;
import com.amazonaws.services.simpleemailv2.model.ReplacementEmailContent;
import com.amazonaws.services.simpleemailv2.model.transform.BulkEmailEntryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BulkEmailEntry
implements Serializable,
Cloneable,
StructuredPojo {
    private Destination destination;
    private List<MessageTag> replacementTags;
    private ReplacementEmailContent replacementEmailContent;

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public BulkEmailEntry withDestination(Destination destination) {
        this.setDestination(destination);
        return this;
    }

    public List<MessageTag> getReplacementTags() {
        return this.replacementTags;
    }

    public void setReplacementTags(Collection<MessageTag> replacementTags) {
        if (replacementTags == null) {
            this.replacementTags = null;
            return;
        }
        this.replacementTags = new ArrayList<MessageTag>(replacementTags);
    }

    public BulkEmailEntry withReplacementTags(MessageTag ... replacementTags) {
        if (this.replacementTags == null) {
            this.setReplacementTags(new ArrayList<MessageTag>(replacementTags.length));
        }
        for (MessageTag ele : replacementTags) {
            this.replacementTags.add(ele);
        }
        return this;
    }

    public BulkEmailEntry withReplacementTags(Collection<MessageTag> replacementTags) {
        this.setReplacementTags(replacementTags);
        return this;
    }

    public void setReplacementEmailContent(ReplacementEmailContent replacementEmailContent) {
        this.replacementEmailContent = replacementEmailContent;
    }

    public ReplacementEmailContent getReplacementEmailContent() {
        return this.replacementEmailContent;
    }

    public BulkEmailEntry withReplacementEmailContent(ReplacementEmailContent replacementEmailContent) {
        this.setReplacementEmailContent(replacementEmailContent);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getReplacementTags() != null) {
            sb.append("ReplacementTags: ").append(this.getReplacementTags()).append(",");
        }
        if (this.getReplacementEmailContent() != null) {
            sb.append("ReplacementEmailContent: ").append(this.getReplacementEmailContent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailEntry)) {
            return false;
        }
        BulkEmailEntry other = (BulkEmailEntry)obj;
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getReplacementTags() == null ^ this.getReplacementTags() == null) {
            return false;
        }
        if (other.getReplacementTags() != null && !other.getReplacementTags().equals(this.getReplacementTags())) {
            return false;
        }
        if (other.getReplacementEmailContent() == null ^ this.getReplacementEmailContent() == null) {
            return false;
        }
        return other.getReplacementEmailContent() == null || other.getReplacementEmailContent().equals(this.getReplacementEmailContent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getReplacementTags() == null ? 0 : this.getReplacementTags().hashCode());
        hashCode = 31 * hashCode + (this.getReplacementEmailContent() == null ? 0 : this.getReplacementEmailContent().hashCode());
        return hashCode;
    }

    public BulkEmailEntry clone() {
        try {
            return (BulkEmailEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BulkEmailEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

