/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleemailv2.model.BulkEmailContent;
import com.amazonaws.services.simpleemailv2.model.BulkEmailEntry;
import com.amazonaws.services.simpleemailv2.model.MessageTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SendBulkEmailRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String fromEmailAddress;
    private String fromEmailAddressIdentityArn;
    private List<String> replyToAddresses;
    private String feedbackForwardingEmailAddress;
    private String feedbackForwardingEmailAddressIdentityArn;
    private List<MessageTag> defaultEmailTags;
    private BulkEmailContent defaultContent;
    private List<BulkEmailEntry> bulkEmailEntries;
    private String configurationSetName;

    public void setFromEmailAddress(String fromEmailAddress) {
        this.fromEmailAddress = fromEmailAddress;
    }

    public String getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    public SendBulkEmailRequest withFromEmailAddress(String fromEmailAddress) {
        this.setFromEmailAddress(fromEmailAddress);
        return this;
    }

    public void setFromEmailAddressIdentityArn(String fromEmailAddressIdentityArn) {
        this.fromEmailAddressIdentityArn = fromEmailAddressIdentityArn;
    }

    public String getFromEmailAddressIdentityArn() {
        return this.fromEmailAddressIdentityArn;
    }

    public SendBulkEmailRequest withFromEmailAddressIdentityArn(String fromEmailAddressIdentityArn) {
        this.setFromEmailAddressIdentityArn(fromEmailAddressIdentityArn);
        return this;
    }

    public List<String> getReplyToAddresses() {
        return this.replyToAddresses;
    }

    public void setReplyToAddresses(Collection<String> replyToAddresses) {
        if (replyToAddresses == null) {
            this.replyToAddresses = null;
            return;
        }
        this.replyToAddresses = new ArrayList<String>(replyToAddresses);
    }

    public SendBulkEmailRequest withReplyToAddresses(String ... replyToAddresses) {
        if (this.replyToAddresses == null) {
            this.setReplyToAddresses(new ArrayList<String>(replyToAddresses.length));
        }
        for (String ele : replyToAddresses) {
            this.replyToAddresses.add(ele);
        }
        return this;
    }

    public SendBulkEmailRequest withReplyToAddresses(Collection<String> replyToAddresses) {
        this.setReplyToAddresses(replyToAddresses);
        return this;
    }

    public void setFeedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
        this.feedbackForwardingEmailAddress = feedbackForwardingEmailAddress;
    }

    public String getFeedbackForwardingEmailAddress() {
        return this.feedbackForwardingEmailAddress;
    }

    public SendBulkEmailRequest withFeedbackForwardingEmailAddress(String feedbackForwardingEmailAddress) {
        this.setFeedbackForwardingEmailAddress(feedbackForwardingEmailAddress);
        return this;
    }

    public void setFeedbackForwardingEmailAddressIdentityArn(String feedbackForwardingEmailAddressIdentityArn) {
        this.feedbackForwardingEmailAddressIdentityArn = feedbackForwardingEmailAddressIdentityArn;
    }

    public String getFeedbackForwardingEmailAddressIdentityArn() {
        return this.feedbackForwardingEmailAddressIdentityArn;
    }

    public SendBulkEmailRequest withFeedbackForwardingEmailAddressIdentityArn(String feedbackForwardingEmailAddressIdentityArn) {
        this.setFeedbackForwardingEmailAddressIdentityArn(feedbackForwardingEmailAddressIdentityArn);
        return this;
    }

    public List<MessageTag> getDefaultEmailTags() {
        return this.defaultEmailTags;
    }

    public void setDefaultEmailTags(Collection<MessageTag> defaultEmailTags) {
        if (defaultEmailTags == null) {
            this.defaultEmailTags = null;
            return;
        }
        this.defaultEmailTags = new ArrayList<MessageTag>(defaultEmailTags);
    }

    public SendBulkEmailRequest withDefaultEmailTags(MessageTag ... defaultEmailTags) {
        if (this.defaultEmailTags == null) {
            this.setDefaultEmailTags(new ArrayList<MessageTag>(defaultEmailTags.length));
        }
        for (MessageTag ele : defaultEmailTags) {
            this.defaultEmailTags.add(ele);
        }
        return this;
    }

    public SendBulkEmailRequest withDefaultEmailTags(Collection<MessageTag> defaultEmailTags) {
        this.setDefaultEmailTags(defaultEmailTags);
        return this;
    }

    public void setDefaultContent(BulkEmailContent defaultContent) {
        this.defaultContent = defaultContent;
    }

    public BulkEmailContent getDefaultContent() {
        return this.defaultContent;
    }

    public SendBulkEmailRequest withDefaultContent(BulkEmailContent defaultContent) {
        this.setDefaultContent(defaultContent);
        return this;
    }

    public List<BulkEmailEntry> getBulkEmailEntries() {
        return this.bulkEmailEntries;
    }

    public void setBulkEmailEntries(Collection<BulkEmailEntry> bulkEmailEntries) {
        if (bulkEmailEntries == null) {
            this.bulkEmailEntries = null;
            return;
        }
        this.bulkEmailEntries = new ArrayList<BulkEmailEntry>(bulkEmailEntries);
    }

    public SendBulkEmailRequest withBulkEmailEntries(BulkEmailEntry ... bulkEmailEntries) {
        if (this.bulkEmailEntries == null) {
            this.setBulkEmailEntries(new ArrayList<BulkEmailEntry>(bulkEmailEntries.length));
        }
        for (BulkEmailEntry ele : bulkEmailEntries) {
            this.bulkEmailEntries.add(ele);
        }
        return this;
    }

    public SendBulkEmailRequest withBulkEmailEntries(Collection<BulkEmailEntry> bulkEmailEntries) {
        this.setBulkEmailEntries(bulkEmailEntries);
        return this;
    }

    public void setConfigurationSetName(String configurationSetName) {
        this.configurationSetName = configurationSetName;
    }

    public String getConfigurationSetName() {
        return this.configurationSetName;
    }

    public SendBulkEmailRequest withConfigurationSetName(String configurationSetName) {
        this.setConfigurationSetName(configurationSetName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFromEmailAddress() != null) {
            sb.append("FromEmailAddress: ").append(this.getFromEmailAddress()).append(",");
        }
        if (this.getFromEmailAddressIdentityArn() != null) {
            sb.append("FromEmailAddressIdentityArn: ").append(this.getFromEmailAddressIdentityArn()).append(",");
        }
        if (this.getReplyToAddresses() != null) {
            sb.append("ReplyToAddresses: ").append(this.getReplyToAddresses()).append(",");
        }
        if (this.getFeedbackForwardingEmailAddress() != null) {
            sb.append("FeedbackForwardingEmailAddress: ").append(this.getFeedbackForwardingEmailAddress()).append(",");
        }
        if (this.getFeedbackForwardingEmailAddressIdentityArn() != null) {
            sb.append("FeedbackForwardingEmailAddressIdentityArn: ").append(this.getFeedbackForwardingEmailAddressIdentityArn()).append(",");
        }
        if (this.getDefaultEmailTags() != null) {
            sb.append("DefaultEmailTags: ").append(this.getDefaultEmailTags()).append(",");
        }
        if (this.getDefaultContent() != null) {
            sb.append("DefaultContent: ").append(this.getDefaultContent()).append(",");
        }
        if (this.getBulkEmailEntries() != null) {
            sb.append("BulkEmailEntries: ").append(this.getBulkEmailEntries()).append(",");
        }
        if (this.getConfigurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(this.getConfigurationSetName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkEmailRequest)) {
            return false;
        }
        SendBulkEmailRequest other = (SendBulkEmailRequest)obj;
        if (other.getFromEmailAddress() == null ^ this.getFromEmailAddress() == null) {
            return false;
        }
        if (other.getFromEmailAddress() != null && !other.getFromEmailAddress().equals(this.getFromEmailAddress())) {
            return false;
        }
        if (other.getFromEmailAddressIdentityArn() == null ^ this.getFromEmailAddressIdentityArn() == null) {
            return false;
        }
        if (other.getFromEmailAddressIdentityArn() != null && !other.getFromEmailAddressIdentityArn().equals(this.getFromEmailAddressIdentityArn())) {
            return false;
        }
        if (other.getReplyToAddresses() == null ^ this.getReplyToAddresses() == null) {
            return false;
        }
        if (other.getReplyToAddresses() != null && !other.getReplyToAddresses().equals(this.getReplyToAddresses())) {
            return false;
        }
        if (other.getFeedbackForwardingEmailAddress() == null ^ this.getFeedbackForwardingEmailAddress() == null) {
            return false;
        }
        if (other.getFeedbackForwardingEmailAddress() != null && !other.getFeedbackForwardingEmailAddress().equals(this.getFeedbackForwardingEmailAddress())) {
            return false;
        }
        if (other.getFeedbackForwardingEmailAddressIdentityArn() == null ^ this.getFeedbackForwardingEmailAddressIdentityArn() == null) {
            return false;
        }
        if (other.getFeedbackForwardingEmailAddressIdentityArn() != null && !other.getFeedbackForwardingEmailAddressIdentityArn().equals(this.getFeedbackForwardingEmailAddressIdentityArn())) {
            return false;
        }
        if (other.getDefaultEmailTags() == null ^ this.getDefaultEmailTags() == null) {
            return false;
        }
        if (other.getDefaultEmailTags() != null && !other.getDefaultEmailTags().equals(this.getDefaultEmailTags())) {
            return false;
        }
        if (other.getDefaultContent() == null ^ this.getDefaultContent() == null) {
            return false;
        }
        if (other.getDefaultContent() != null && !other.getDefaultContent().equals(this.getDefaultContent())) {
            return false;
        }
        if (other.getBulkEmailEntries() == null ^ this.getBulkEmailEntries() == null) {
            return false;
        }
        if (other.getBulkEmailEntries() != null && !other.getBulkEmailEntries().equals(this.getBulkEmailEntries())) {
            return false;
        }
        if (other.getConfigurationSetName() == null ^ this.getConfigurationSetName() == null) {
            return false;
        }
        return other.getConfigurationSetName() == null || other.getConfigurationSetName().equals(this.getConfigurationSetName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFromEmailAddress() == null ? 0 : this.getFromEmailAddress().hashCode());
        hashCode = 31 * hashCode + (this.getFromEmailAddressIdentityArn() == null ? 0 : this.getFromEmailAddressIdentityArn().hashCode());
        hashCode = 31 * hashCode + (this.getReplyToAddresses() == null ? 0 : this.getReplyToAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackForwardingEmailAddress() == null ? 0 : this.getFeedbackForwardingEmailAddress().hashCode());
        hashCode = 31 * hashCode + (this.getFeedbackForwardingEmailAddressIdentityArn() == null ? 0 : this.getFeedbackForwardingEmailAddressIdentityArn().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultEmailTags() == null ? 0 : this.getDefaultEmailTags().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultContent() == null ? 0 : this.getDefaultContent().hashCode());
        hashCode = 31 * hashCode + (this.getBulkEmailEntries() == null ? 0 : this.getBulkEmailEntries().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationSetName() == null ? 0 : this.getConfigurationSetName().hashCode());
        return hashCode;
    }

    public SendBulkEmailRequest clone() {
        return (SendBulkEmailRequest)super.clone();
    }
}

