/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.signer.model.SigningJob;
import java.util.Date;

@SdkInternalApi
public class SigningJobMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<StructuredPojo> SIGNEDOBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signedObject").build();
    private static final MarshallingInfo<StructuredPojo> SIGNINGMATERIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("signingMaterial").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final SigningJobMarshaller instance = new SigningJobMarshaller();

    public static SigningJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(SigningJob signingJob, ProtocolMarshaller protocolMarshaller) {
        if (signingJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)signingJob.getJobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)signingJob.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)signingJob.getSignedObject(), SIGNEDOBJECT_BINDING);
            protocolMarshaller.marshall((Object)signingJob.getSigningMaterial(), SIGNINGMATERIAL_BINDING);
            protocolMarshaller.marshall((Object)signingJob.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)signingJob.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

