/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowdevicemanagement.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.snowdevicemanagement.model.ExecutionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListExecutionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ExecutionSummary> executions;
    private String nextToken;

    public List<ExecutionSummary> getExecutions() {
        return this.executions;
    }

    public void setExecutions(Collection<ExecutionSummary> executions) {
        if (executions == null) {
            this.executions = null;
            return;
        }
        this.executions = new ArrayList<ExecutionSummary>(executions);
    }

    public ListExecutionsResult withExecutions(ExecutionSummary ... executions) {
        if (this.executions == null) {
            this.setExecutions(new ArrayList<ExecutionSummary>(executions.length));
        }
        for (ExecutionSummary ele : executions) {
            this.executions.add(ele);
        }
        return this;
    }

    public ListExecutionsResult withExecutions(Collection<ExecutionSummary> executions) {
        this.setExecutions(executions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListExecutionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExecutions() != null) {
            sb.append("Executions: ").append(this.getExecutions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsResult)) {
            return false;
        }
        ListExecutionsResult other = (ListExecutionsResult)obj;
        if (other.getExecutions() == null ^ this.getExecutions() == null) {
            return false;
        }
        if (other.getExecutions() != null && !other.getExecutions().equals(this.getExecutions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExecutions() == null ? 0 : this.getExecutions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListExecutionsResult clone() {
        try {
            return (ListExecutionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

