/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.OpsItemDataValue;
import com.amazonaws.services.simplesystemsmanagement.model.OpsItemNotification;
import com.amazonaws.services.simplesystemsmanagement.model.OpsItemStatus;
import com.amazonaws.services.simplesystemsmanagement.model.RelatedOpsItem;
import com.amazonaws.services.simplesystemsmanagement.model.transform.OpsItemMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpsItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String createdBy;
    private Date createdTime;
    private String description;
    private String lastModifiedBy;
    private Date lastModifiedTime;
    private SdkInternalList<OpsItemNotification> notifications;
    private Integer priority;
    private SdkInternalList<RelatedOpsItem> relatedOpsItems;
    private String status;
    private String opsItemId;
    private String version;
    private String title;
    private String source;
    private Map<String, OpsItemDataValue> operationalData;

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OpsItem withCreatedBy(String createdBy) {
        this.setCreatedBy(createdBy);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public OpsItem withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public OpsItem withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public OpsItem withLastModifiedBy(String lastModifiedBy) {
        this.setLastModifiedBy(lastModifiedBy);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public OpsItem withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public List<OpsItemNotification> getNotifications() {
        if (this.notifications == null) {
            this.notifications = new SdkInternalList();
        }
        return this.notifications;
    }

    public void setNotifications(Collection<OpsItemNotification> notifications) {
        if (notifications == null) {
            this.notifications = null;
            return;
        }
        this.notifications = new SdkInternalList(notifications);
    }

    public OpsItem withNotifications(OpsItemNotification ... notifications) {
        if (this.notifications == null) {
            this.setNotifications((Collection<OpsItemNotification>)new SdkInternalList(notifications.length));
        }
        for (OpsItemNotification ele : notifications) {
            this.notifications.add((Object)ele);
        }
        return this;
    }

    public OpsItem withNotifications(Collection<OpsItemNotification> notifications) {
        this.setNotifications(notifications);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public OpsItem withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public List<RelatedOpsItem> getRelatedOpsItems() {
        if (this.relatedOpsItems == null) {
            this.relatedOpsItems = new SdkInternalList();
        }
        return this.relatedOpsItems;
    }

    public void setRelatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
        if (relatedOpsItems == null) {
            this.relatedOpsItems = null;
            return;
        }
        this.relatedOpsItems = new SdkInternalList(relatedOpsItems);
    }

    public OpsItem withRelatedOpsItems(RelatedOpsItem ... relatedOpsItems) {
        if (this.relatedOpsItems == null) {
            this.setRelatedOpsItems((Collection<RelatedOpsItem>)new SdkInternalList(relatedOpsItems.length));
        }
        for (RelatedOpsItem ele : relatedOpsItems) {
            this.relatedOpsItems.add((Object)ele);
        }
        return this;
    }

    public OpsItem withRelatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
        this.setRelatedOpsItems(relatedOpsItems);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public OpsItem withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public OpsItem withStatus(OpsItemStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setOpsItemId(String opsItemId) {
        this.opsItemId = opsItemId;
    }

    public String getOpsItemId() {
        return this.opsItemId;
    }

    public OpsItem withOpsItemId(String opsItemId) {
        this.setOpsItemId(opsItemId);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public OpsItem withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public OpsItem withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public OpsItem withSource(String source) {
        this.setSource(source);
        return this;
    }

    public Map<String, OpsItemDataValue> getOperationalData() {
        return this.operationalData;
    }

    public void setOperationalData(Map<String, OpsItemDataValue> operationalData) {
        this.operationalData = operationalData;
    }

    public OpsItem withOperationalData(Map<String, OpsItemDataValue> operationalData) {
        this.setOperationalData(operationalData);
        return this;
    }

    public OpsItem addOperationalDataEntry(String key, OpsItemDataValue value) {
        if (null == this.operationalData) {
            this.operationalData = new HashMap<String, OpsItemDataValue>();
        }
        if (this.operationalData.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.operationalData.put(key, value);
        return this;
    }

    public OpsItem clearOperationalDataEntries() {
        this.operationalData = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreatedBy() != null) {
            sb.append("CreatedBy: ").append(this.getCreatedBy()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getLastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.getLastModifiedBy()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getNotifications() != null) {
            sb.append("Notifications: ").append(this.getNotifications()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getRelatedOpsItems() != null) {
            sb.append("RelatedOpsItems: ").append(this.getRelatedOpsItems()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getOpsItemId() != null) {
            sb.append("OpsItemId: ").append(this.getOpsItemId()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getOperationalData() != null) {
            sb.append("OperationalData: ").append(this.getOperationalData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItem)) {
            return false;
        }
        OpsItem other = (OpsItem)obj;
        if (other.getCreatedBy() == null ^ this.getCreatedBy() == null) {
            return false;
        }
        if (other.getCreatedBy() != null && !other.getCreatedBy().equals(this.getCreatedBy())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLastModifiedBy() == null ^ this.getLastModifiedBy() == null) {
            return false;
        }
        if (other.getLastModifiedBy() != null && !other.getLastModifiedBy().equals(this.getLastModifiedBy())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getNotifications() == null ^ this.getNotifications() == null) {
            return false;
        }
        if (other.getNotifications() != null && !other.getNotifications().equals(this.getNotifications())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getRelatedOpsItems() == null ^ this.getRelatedOpsItems() == null) {
            return false;
        }
        if (other.getRelatedOpsItems() != null && !other.getRelatedOpsItems().equals(this.getRelatedOpsItems())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getOpsItemId() == null ^ this.getOpsItemId() == null) {
            return false;
        }
        if (other.getOpsItemId() != null && !other.getOpsItemId().equals(this.getOpsItemId())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getOperationalData() == null ^ this.getOperationalData() == null) {
            return false;
        }
        return other.getOperationalData() == null || other.getOperationalData().equals(this.getOperationalData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getNotifications() == null ? 0 : this.getNotifications().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedOpsItems() == null ? 0 : this.getRelatedOpsItems().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getOpsItemId() == null ? 0 : this.getOpsItemId().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getOperationalData() == null ? 0 : this.getOperationalData().hashCode());
        return hashCode;
    }

    public OpsItem clone() {
        try {
            return (OpsItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpsItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

