/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sso.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.sso.model.AccountInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAccountsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<AccountInfo> accountList;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAccountsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<AccountInfo> getAccountList() {
        return this.accountList;
    }

    public void setAccountList(Collection<AccountInfo> accountList) {
        if (accountList == null) {
            this.accountList = null;
            return;
        }
        this.accountList = new ArrayList<AccountInfo>(accountList);
    }

    public ListAccountsResult withAccountList(AccountInfo ... accountList) {
        if (this.accountList == null) {
            this.setAccountList(new ArrayList<AccountInfo>(accountList.length));
        }
        for (AccountInfo ele : accountList) {
            this.accountList.add(ele);
        }
        return this;
    }

    public ListAccountsResult withAccountList(Collection<AccountInfo> accountList) {
        this.setAccountList(accountList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getAccountList() != null) {
            sb.append("AccountList: ").append(this.getAccountList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsResult)) {
            return false;
        }
        ListAccountsResult other = (ListAccountsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getAccountList() == null ^ this.getAccountList() == null) {
            return false;
        }
        return other.getAccountList() == null || other.getAccountList().equals(this.getAccountList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getAccountList() == null ? 0 : this.getAccountList().hashCode());
        return hashCode;
    }

    public ListAccountsResult clone() {
        try {
            return (ListAccountsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

