/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssoadmin.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssoadmin.model.ResourceServerScopeDetails;
import com.amazonaws.services.ssoadmin.model.transform.ResourceServerConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ResourceServerConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, ResourceServerScopeDetails> scopes;

    public Map<String, ResourceServerScopeDetails> getScopes() {
        return this.scopes;
    }

    public void setScopes(Map<String, ResourceServerScopeDetails> scopes) {
        this.scopes = scopes;
    }

    public ResourceServerConfig withScopes(Map<String, ResourceServerScopeDetails> scopes) {
        this.setScopes(scopes);
        return this;
    }

    public ResourceServerConfig addScopesEntry(String key, ResourceServerScopeDetails value) {
        if (null == this.scopes) {
            this.scopes = new HashMap<String, ResourceServerScopeDetails>();
        }
        if (this.scopes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.scopes.put(key, value);
        return this;
    }

    public ResourceServerConfig clearScopesEntries() {
        this.scopes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScopes() != null) {
            sb.append("Scopes: ").append(this.getScopes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceServerConfig)) {
            return false;
        }
        ResourceServerConfig other = (ResourceServerConfig)obj;
        if (other.getScopes() == null ^ this.getScopes() == null) {
            return false;
        }
        return other.getScopes() == null || other.getScopes().equals(this.getScopes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScopes() == null ? 0 : this.getScopes().hashCode());
        return hashCode;
    }

    public ResourceServerConfig clone() {
        try {
            return (ResourceServerConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceServerConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

