/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.Extraction;
import com.amazonaws.services.textract.model.PageClassification;
import com.amazonaws.services.textract.model.transform.LendingResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LendingResult
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer page;
    private PageClassification pageClassification;
    private List<Extraction> extractions;

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPage() {
        return this.page;
    }

    public LendingResult withPage(Integer page) {
        this.setPage(page);
        return this;
    }

    public void setPageClassification(PageClassification pageClassification) {
        this.pageClassification = pageClassification;
    }

    public PageClassification getPageClassification() {
        return this.pageClassification;
    }

    public LendingResult withPageClassification(PageClassification pageClassification) {
        this.setPageClassification(pageClassification);
        return this;
    }

    public List<Extraction> getExtractions() {
        return this.extractions;
    }

    public void setExtractions(Collection<Extraction> extractions) {
        if (extractions == null) {
            this.extractions = null;
            return;
        }
        this.extractions = new ArrayList<Extraction>(extractions);
    }

    public LendingResult withExtractions(Extraction ... extractions) {
        if (this.extractions == null) {
            this.setExtractions(new ArrayList<Extraction>(extractions.length));
        }
        for (Extraction ele : extractions) {
            this.extractions.add(ele);
        }
        return this;
    }

    public LendingResult withExtractions(Collection<Extraction> extractions) {
        this.setExtractions(extractions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPage() != null) {
            sb.append("Page: ").append(this.getPage()).append(",");
        }
        if (this.getPageClassification() != null) {
            sb.append("PageClassification: ").append(this.getPageClassification()).append(",");
        }
        if (this.getExtractions() != null) {
            sb.append("Extractions: ").append(this.getExtractions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingResult)) {
            return false;
        }
        LendingResult other = (LendingResult)obj;
        if (other.getPage() == null ^ this.getPage() == null) {
            return false;
        }
        if (other.getPage() != null && !other.getPage().equals(this.getPage())) {
            return false;
        }
        if (other.getPageClassification() == null ^ this.getPageClassification() == null) {
            return false;
        }
        if (other.getPageClassification() != null && !other.getPageClassification().equals(this.getPageClassification())) {
            return false;
        }
        if (other.getExtractions() == null ^ this.getExtractions() == null) {
            return false;
        }
        return other.getExtractions() == null || other.getExtractions().equals(this.getExtractions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPage() == null ? 0 : this.getPage().hashCode());
        hashCode = 31 * hashCode + (this.getPageClassification() == null ? 0 : this.getPageClassification().hashCode());
        hashCode = 31 * hashCode + (this.getExtractions() == null ? 0 : this.getExtractions().hashCode());
        return hashCode;
    }

    public LendingResult clone() {
        try {
            return (LendingResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LendingResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

