/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.Extraction;

@SdkInternalApi
public class ExtractionMarshaller {
    private static final MarshallingInfo<StructuredPojo> LENDINGDOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LendingDocument").build();
    private static final MarshallingInfo<StructuredPojo> EXPENSEDOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpenseDocument").build();
    private static final MarshallingInfo<StructuredPojo> IDENTITYDOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityDocument").build();
    private static final ExtractionMarshaller instance = new ExtractionMarshaller();

    public static ExtractionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Extraction extraction, ProtocolMarshaller protocolMarshaller) {
        if (extraction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)extraction.getLendingDocument(), LENDINGDOCUMENT_BINDING);
            protocolMarshaller.marshall((Object)extraction.getExpenseDocument(), EXPENSEDOCUMENT_BINDING);
            protocolMarshaller.marshall((Object)extraction.getIdentityDocument(), IDENTITYDOCUMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

