/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Amazon Timestream Write</fullname>
 * <p>
 * Amazon Timestream is a fast, scalable, fully managed time-series database service that makes it easy to store and
 * analyze trillions of time-series data points per day. With Timestream, you can easily store and analyze IoT sensor
 * data to derive insights from your IoT applications. You can analyze industrial telemetry to streamline equipment
 * management and maintenance. You can also store and analyze log data and metrics to improve the performance and
 * availability of your applications.
 * </p>
 * <p>
 * Timestream is built from the ground up to effectively ingest, process, and store time-series data. It organizes data
 * to optimize query processing. It automatically scales based on the volume of data ingested and on the query volume to
 * ensure you receive optimal performance while inserting and querying data. As your data grows over time, Timestream’s
 * adaptive query processing engine spans across storage tiers to provide fast analysis while reducing costs.
 * </p>
 */
package com.amazonaws.services.timestreamwrite;

