/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.timestreamwrite.model.DataModel;
import java.util.List;

@SdkInternalApi
public class DataModelMarshaller {
    private static final MarshallingInfo<String> TIMECOLUMN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeColumn").build();
    private static final MarshallingInfo<String> TIMEUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeUnit").build();
    private static final MarshallingInfo<List> DIMENSIONMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DimensionMappings").build();
    private static final MarshallingInfo<StructuredPojo> MULTIMEASUREMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiMeasureMappings").build();
    private static final MarshallingInfo<List> MIXEDMEASUREMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MixedMeasureMappings").build();
    private static final MarshallingInfo<String> MEASURENAMECOLUMN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MeasureNameColumn").build();
    private static final DataModelMarshaller instance = new DataModelMarshaller();

    public static DataModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataModel dataModel, ProtocolMarshaller protocolMarshaller) {
        if (dataModel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataModel.getTimeColumn(), TIMECOLUMN_BINDING);
            protocolMarshaller.marshall((Object)dataModel.getTimeUnit(), TIMEUNIT_BINDING);
            protocolMarshaller.marshall(dataModel.getDimensionMappings(), DIMENSIONMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)dataModel.getMultiMeasureMappings(), MULTIMEASUREMAPPINGS_BINDING);
            protocolMarshaller.marshall(dataModel.getMixedMeasureMappings(), MIXEDMEASUREMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)dataModel.getMeasureNameColumn(), MEASURENAMECOLUMN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

