/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.AbsoluteTimeRange;
import com.amazonaws.services.transcribe.model.ParticipantRole;
import com.amazonaws.services.transcribe.model.RelativeTimeRange;
import com.amazonaws.services.transcribe.model.SentimentValue;
import com.amazonaws.services.transcribe.model.transform.SentimentFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SentimentFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> sentiments;
    private AbsoluteTimeRange absoluteTimeRange;
    private RelativeTimeRange relativeTimeRange;
    private String participantRole;
    private Boolean negate;

    public List<String> getSentiments() {
        return this.sentiments;
    }

    public void setSentiments(Collection<String> sentiments) {
        if (sentiments == null) {
            this.sentiments = null;
            return;
        }
        this.sentiments = new ArrayList<String>(sentiments);
    }

    public SentimentFilter withSentiments(String ... sentiments) {
        if (this.sentiments == null) {
            this.setSentiments(new ArrayList<String>(sentiments.length));
        }
        for (String ele : sentiments) {
            this.sentiments.add(ele);
        }
        return this;
    }

    public SentimentFilter withSentiments(Collection<String> sentiments) {
        this.setSentiments(sentiments);
        return this;
    }

    public SentimentFilter withSentiments(SentimentValue ... sentiments) {
        ArrayList<String> sentimentsCopy = new ArrayList<String>(sentiments.length);
        for (SentimentValue value : sentiments) {
            sentimentsCopy.add(value.toString());
        }
        if (this.getSentiments() == null) {
            this.setSentiments(sentimentsCopy);
        } else {
            this.getSentiments().addAll(sentimentsCopy);
        }
        return this;
    }

    public void setAbsoluteTimeRange(AbsoluteTimeRange absoluteTimeRange) {
        this.absoluteTimeRange = absoluteTimeRange;
    }

    public AbsoluteTimeRange getAbsoluteTimeRange() {
        return this.absoluteTimeRange;
    }

    public SentimentFilter withAbsoluteTimeRange(AbsoluteTimeRange absoluteTimeRange) {
        this.setAbsoluteTimeRange(absoluteTimeRange);
        return this;
    }

    public void setRelativeTimeRange(RelativeTimeRange relativeTimeRange) {
        this.relativeTimeRange = relativeTimeRange;
    }

    public RelativeTimeRange getRelativeTimeRange() {
        return this.relativeTimeRange;
    }

    public SentimentFilter withRelativeTimeRange(RelativeTimeRange relativeTimeRange) {
        this.setRelativeTimeRange(relativeTimeRange);
        return this;
    }

    public void setParticipantRole(String participantRole) {
        this.participantRole = participantRole;
    }

    public String getParticipantRole() {
        return this.participantRole;
    }

    public SentimentFilter withParticipantRole(String participantRole) {
        this.setParticipantRole(participantRole);
        return this;
    }

    public SentimentFilter withParticipantRole(ParticipantRole participantRole) {
        this.participantRole = participantRole.toString();
        return this;
    }

    public void setNegate(Boolean negate) {
        this.negate = negate;
    }

    public Boolean getNegate() {
        return this.negate;
    }

    public SentimentFilter withNegate(Boolean negate) {
        this.setNegate(negate);
        return this;
    }

    public Boolean isNegate() {
        return this.negate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSentiments() != null) {
            sb.append("Sentiments: ").append(this.getSentiments()).append(",");
        }
        if (this.getAbsoluteTimeRange() != null) {
            sb.append("AbsoluteTimeRange: ").append(this.getAbsoluteTimeRange()).append(",");
        }
        if (this.getRelativeTimeRange() != null) {
            sb.append("RelativeTimeRange: ").append(this.getRelativeTimeRange()).append(",");
        }
        if (this.getParticipantRole() != null) {
            sb.append("ParticipantRole: ").append(this.getParticipantRole()).append(",");
        }
        if (this.getNegate() != null) {
            sb.append("Negate: ").append(this.getNegate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SentimentFilter)) {
            return false;
        }
        SentimentFilter other = (SentimentFilter)obj;
        if (other.getSentiments() == null ^ this.getSentiments() == null) {
            return false;
        }
        if (other.getSentiments() != null && !other.getSentiments().equals(this.getSentiments())) {
            return false;
        }
        if (other.getAbsoluteTimeRange() == null ^ this.getAbsoluteTimeRange() == null) {
            return false;
        }
        if (other.getAbsoluteTimeRange() != null && !other.getAbsoluteTimeRange().equals(this.getAbsoluteTimeRange())) {
            return false;
        }
        if (other.getRelativeTimeRange() == null ^ this.getRelativeTimeRange() == null) {
            return false;
        }
        if (other.getRelativeTimeRange() != null && !other.getRelativeTimeRange().equals(this.getRelativeTimeRange())) {
            return false;
        }
        if (other.getParticipantRole() == null ^ this.getParticipantRole() == null) {
            return false;
        }
        if (other.getParticipantRole() != null && !other.getParticipantRole().equals(this.getParticipantRole())) {
            return false;
        }
        if (other.getNegate() == null ^ this.getNegate() == null) {
            return false;
        }
        return other.getNegate() == null || other.getNegate().equals(this.getNegate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSentiments() == null ? 0 : this.getSentiments().hashCode());
        hashCode = 31 * hashCode + (this.getAbsoluteTimeRange() == null ? 0 : this.getAbsoluteTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getRelativeTimeRange() == null ? 0 : this.getRelativeTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getParticipantRole() == null ? 0 : this.getParticipantRole().hashCode());
        hashCode = 31 * hashCode + (this.getNegate() == null ? 0 : this.getNegate().hashCode());
        return hashCode;
    }

    public SentimentFilter clone() {
        try {
            return (SentimentFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SentimentFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

