/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.ExecutionStepResult;
import com.amazonaws.services.transfer.model.transform.ExecutionResultsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExecutionResults
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ExecutionStepResult> steps;
    private List<ExecutionStepResult> onExceptionSteps;

    public List<ExecutionStepResult> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<ExecutionStepResult> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<ExecutionStepResult>(steps);
    }

    public ExecutionResults withSteps(ExecutionStepResult ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<ExecutionStepResult>(steps.length));
        }
        for (ExecutionStepResult ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public ExecutionResults withSteps(Collection<ExecutionStepResult> steps) {
        this.setSteps(steps);
        return this;
    }

    public List<ExecutionStepResult> getOnExceptionSteps() {
        return this.onExceptionSteps;
    }

    public void setOnExceptionSteps(Collection<ExecutionStepResult> onExceptionSteps) {
        if (onExceptionSteps == null) {
            this.onExceptionSteps = null;
            return;
        }
        this.onExceptionSteps = new ArrayList<ExecutionStepResult>(onExceptionSteps);
    }

    public ExecutionResults withOnExceptionSteps(ExecutionStepResult ... onExceptionSteps) {
        if (this.onExceptionSteps == null) {
            this.setOnExceptionSteps(new ArrayList<ExecutionStepResult>(onExceptionSteps.length));
        }
        for (ExecutionStepResult ele : onExceptionSteps) {
            this.onExceptionSteps.add(ele);
        }
        return this;
    }

    public ExecutionResults withOnExceptionSteps(Collection<ExecutionStepResult> onExceptionSteps) {
        this.setOnExceptionSteps(onExceptionSteps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps()).append(",");
        }
        if (this.getOnExceptionSteps() != null) {
            sb.append("OnExceptionSteps: ").append(this.getOnExceptionSteps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionResults)) {
            return false;
        }
        ExecutionResults other = (ExecutionResults)obj;
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !other.getSteps().equals(this.getSteps())) {
            return false;
        }
        if (other.getOnExceptionSteps() == null ^ this.getOnExceptionSteps() == null) {
            return false;
        }
        return other.getOnExceptionSteps() == null || other.getOnExceptionSteps().equals(this.getOnExceptionSteps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        hashCode = 31 * hashCode + (this.getOnExceptionSteps() == null ? 0 : this.getOnExceptionSteps().hashCode());
        return hashCode;
    }

    public ExecutionResults clone() {
        try {
            return (ExecutionResults)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionResultsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

