/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.translate.model.EncryptionKey;
import com.amazonaws.services.translate.model.MergeStrategy;
import com.amazonaws.services.translate.model.Tag;
import com.amazonaws.services.translate.model.TerminologyData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportTerminologyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String mergeStrategy;
    private String description;
    private TerminologyData terminologyData;
    private EncryptionKey encryptionKey;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ImportTerminologyRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setMergeStrategy(String mergeStrategy) {
        this.mergeStrategy = mergeStrategy;
    }

    public String getMergeStrategy() {
        return this.mergeStrategy;
    }

    public ImportTerminologyRequest withMergeStrategy(String mergeStrategy) {
        this.setMergeStrategy(mergeStrategy);
        return this;
    }

    public ImportTerminologyRequest withMergeStrategy(MergeStrategy mergeStrategy) {
        this.mergeStrategy = mergeStrategy.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImportTerminologyRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTerminologyData(TerminologyData terminologyData) {
        this.terminologyData = terminologyData;
    }

    public TerminologyData getTerminologyData() {
        return this.terminologyData;
    }

    public ImportTerminologyRequest withTerminologyData(TerminologyData terminologyData) {
        this.setTerminologyData(terminologyData);
        return this;
    }

    public void setEncryptionKey(EncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public EncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public ImportTerminologyRequest withEncryptionKey(EncryptionKey encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ImportTerminologyRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ImportTerminologyRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getMergeStrategy() != null) {
            sb.append("MergeStrategy: ").append(this.getMergeStrategy()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTerminologyData() != null) {
            sb.append("TerminologyData: ").append(this.getTerminologyData()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTerminologyRequest)) {
            return false;
        }
        ImportTerminologyRequest other = (ImportTerminologyRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getMergeStrategy() == null ^ this.getMergeStrategy() == null) {
            return false;
        }
        if (other.getMergeStrategy() != null && !other.getMergeStrategy().equals(this.getMergeStrategy())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTerminologyData() == null ^ this.getTerminologyData() == null) {
            return false;
        }
        if (other.getTerminologyData() != null && !other.getTerminologyData().equals(this.getTerminologyData())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getMergeStrategy() == null ? 0 : this.getMergeStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTerminologyData() == null ? 0 : this.getTerminologyData().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ImportTerminologyRequest clone() {
        return (ImportTerminologyRequest)super.clone();
    }
}

