/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.translate.model.AppliedTerminology;
import com.amazonaws.services.translate.model.TranslationSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TranslateTextResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String translatedText;
    private String sourceLanguageCode;
    private String targetLanguageCode;
    private List<AppliedTerminology> appliedTerminologies;
    private TranslationSettings appliedSettings;

    public void setTranslatedText(String translatedText) {
        this.translatedText = translatedText;
    }

    public String getTranslatedText() {
        return this.translatedText;
    }

    public TranslateTextResult withTranslatedText(String translatedText) {
        this.setTranslatedText(translatedText);
        return this;
    }

    public void setSourceLanguageCode(String sourceLanguageCode) {
        this.sourceLanguageCode = sourceLanguageCode;
    }

    public String getSourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public TranslateTextResult withSourceLanguageCode(String sourceLanguageCode) {
        this.setSourceLanguageCode(sourceLanguageCode);
        return this;
    }

    public void setTargetLanguageCode(String targetLanguageCode) {
        this.targetLanguageCode = targetLanguageCode;
    }

    public String getTargetLanguageCode() {
        return this.targetLanguageCode;
    }

    public TranslateTextResult withTargetLanguageCode(String targetLanguageCode) {
        this.setTargetLanguageCode(targetLanguageCode);
        return this;
    }

    public List<AppliedTerminology> getAppliedTerminologies() {
        return this.appliedTerminologies;
    }

    public void setAppliedTerminologies(Collection<AppliedTerminology> appliedTerminologies) {
        if (appliedTerminologies == null) {
            this.appliedTerminologies = null;
            return;
        }
        this.appliedTerminologies = new ArrayList<AppliedTerminology>(appliedTerminologies);
    }

    public TranslateTextResult withAppliedTerminologies(AppliedTerminology ... appliedTerminologies) {
        if (this.appliedTerminologies == null) {
            this.setAppliedTerminologies(new ArrayList<AppliedTerminology>(appliedTerminologies.length));
        }
        for (AppliedTerminology ele : appliedTerminologies) {
            this.appliedTerminologies.add(ele);
        }
        return this;
    }

    public TranslateTextResult withAppliedTerminologies(Collection<AppliedTerminology> appliedTerminologies) {
        this.setAppliedTerminologies(appliedTerminologies);
        return this;
    }

    public void setAppliedSettings(TranslationSettings appliedSettings) {
        this.appliedSettings = appliedSettings;
    }

    public TranslationSettings getAppliedSettings() {
        return this.appliedSettings;
    }

    public TranslateTextResult withAppliedSettings(TranslationSettings appliedSettings) {
        this.setAppliedSettings(appliedSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTranslatedText() != null) {
            sb.append("TranslatedText: ").append(this.getTranslatedText()).append(",");
        }
        if (this.getSourceLanguageCode() != null) {
            sb.append("SourceLanguageCode: ").append(this.getSourceLanguageCode()).append(",");
        }
        if (this.getTargetLanguageCode() != null) {
            sb.append("TargetLanguageCode: ").append(this.getTargetLanguageCode()).append(",");
        }
        if (this.getAppliedTerminologies() != null) {
            sb.append("AppliedTerminologies: ").append(this.getAppliedTerminologies()).append(",");
        }
        if (this.getAppliedSettings() != null) {
            sb.append("AppliedSettings: ").append(this.getAppliedSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextResult)) {
            return false;
        }
        TranslateTextResult other = (TranslateTextResult)obj;
        if (other.getTranslatedText() == null ^ this.getTranslatedText() == null) {
            return false;
        }
        if (other.getTranslatedText() != null && !other.getTranslatedText().equals(this.getTranslatedText())) {
            return false;
        }
        if (other.getSourceLanguageCode() == null ^ this.getSourceLanguageCode() == null) {
            return false;
        }
        if (other.getSourceLanguageCode() != null && !other.getSourceLanguageCode().equals(this.getSourceLanguageCode())) {
            return false;
        }
        if (other.getTargetLanguageCode() == null ^ this.getTargetLanguageCode() == null) {
            return false;
        }
        if (other.getTargetLanguageCode() != null && !other.getTargetLanguageCode().equals(this.getTargetLanguageCode())) {
            return false;
        }
        if (other.getAppliedTerminologies() == null ^ this.getAppliedTerminologies() == null) {
            return false;
        }
        if (other.getAppliedTerminologies() != null && !other.getAppliedTerminologies().equals(this.getAppliedTerminologies())) {
            return false;
        }
        if (other.getAppliedSettings() == null ^ this.getAppliedSettings() == null) {
            return false;
        }
        return other.getAppliedSettings() == null || other.getAppliedSettings().equals(this.getAppliedSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTranslatedText() == null ? 0 : this.getTranslatedText().hashCode());
        hashCode = 31 * hashCode + (this.getSourceLanguageCode() == null ? 0 : this.getSourceLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLanguageCode() == null ? 0 : this.getTargetLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getAppliedTerminologies() == null ? 0 : this.getAppliedTerminologies().hashCode());
        hashCode = 31 * hashCode + (this.getAppliedSettings() == null ? 0 : this.getAppliedSettings().hashCode());
        return hashCode;
    }

    public TranslateTextResult clone() {
        try {
            return (TranslateTextResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

