/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.voiceid;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.voiceid.AmazonVoiceID;
import com.amazonaws.services.voiceid.AmazonVoiceIDClientBuilder;
import com.amazonaws.services.voiceid.model.AmazonVoiceIDException;
import com.amazonaws.services.voiceid.model.CreateDomainRequest;
import com.amazonaws.services.voiceid.model.CreateDomainResult;
import com.amazonaws.services.voiceid.model.DeleteDomainRequest;
import com.amazonaws.services.voiceid.model.DeleteDomainResult;
import com.amazonaws.services.voiceid.model.DeleteFraudsterRequest;
import com.amazonaws.services.voiceid.model.DeleteFraudsterResult;
import com.amazonaws.services.voiceid.model.DeleteSpeakerRequest;
import com.amazonaws.services.voiceid.model.DeleteSpeakerResult;
import com.amazonaws.services.voiceid.model.DescribeDomainRequest;
import com.amazonaws.services.voiceid.model.DescribeDomainResult;
import com.amazonaws.services.voiceid.model.DescribeFraudsterRegistrationJobRequest;
import com.amazonaws.services.voiceid.model.DescribeFraudsterRegistrationJobResult;
import com.amazonaws.services.voiceid.model.DescribeFraudsterRequest;
import com.amazonaws.services.voiceid.model.DescribeFraudsterResult;
import com.amazonaws.services.voiceid.model.DescribeSpeakerEnrollmentJobRequest;
import com.amazonaws.services.voiceid.model.DescribeSpeakerEnrollmentJobResult;
import com.amazonaws.services.voiceid.model.DescribeSpeakerRequest;
import com.amazonaws.services.voiceid.model.DescribeSpeakerResult;
import com.amazonaws.services.voiceid.model.EvaluateSessionRequest;
import com.amazonaws.services.voiceid.model.EvaluateSessionResult;
import com.amazonaws.services.voiceid.model.ListDomainsRequest;
import com.amazonaws.services.voiceid.model.ListDomainsResult;
import com.amazonaws.services.voiceid.model.ListFraudsterRegistrationJobsRequest;
import com.amazonaws.services.voiceid.model.ListFraudsterRegistrationJobsResult;
import com.amazonaws.services.voiceid.model.ListSpeakerEnrollmentJobsRequest;
import com.amazonaws.services.voiceid.model.ListSpeakerEnrollmentJobsResult;
import com.amazonaws.services.voiceid.model.ListSpeakersRequest;
import com.amazonaws.services.voiceid.model.ListSpeakersResult;
import com.amazonaws.services.voiceid.model.ListTagsForResourceRequest;
import com.amazonaws.services.voiceid.model.ListTagsForResourceResult;
import com.amazonaws.services.voiceid.model.OptOutSpeakerRequest;
import com.amazonaws.services.voiceid.model.OptOutSpeakerResult;
import com.amazonaws.services.voiceid.model.StartFraudsterRegistrationJobRequest;
import com.amazonaws.services.voiceid.model.StartFraudsterRegistrationJobResult;
import com.amazonaws.services.voiceid.model.StartSpeakerEnrollmentJobRequest;
import com.amazonaws.services.voiceid.model.StartSpeakerEnrollmentJobResult;
import com.amazonaws.services.voiceid.model.TagResourceRequest;
import com.amazonaws.services.voiceid.model.TagResourceResult;
import com.amazonaws.services.voiceid.model.UntagResourceRequest;
import com.amazonaws.services.voiceid.model.UntagResourceResult;
import com.amazonaws.services.voiceid.model.UpdateDomainRequest;
import com.amazonaws.services.voiceid.model.UpdateDomainResult;
import com.amazonaws.services.voiceid.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.CreateDomainRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.CreateDomainResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.DeleteDomainRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.DeleteDomainResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.DeleteFraudsterRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.DeleteFraudsterResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.DeleteSpeakerRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.DeleteSpeakerResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeDomainRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeDomainResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeFraudsterRegistrationJobRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeFraudsterRegistrationJobResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeFraudsterRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeFraudsterResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeSpeakerEnrollmentJobRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeSpeakerEnrollmentJobResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeSpeakerRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.DescribeSpeakerResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.EvaluateSessionRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.EvaluateSessionResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ListDomainsRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.ListDomainsResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ListFraudsterRegistrationJobsRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.ListFraudsterRegistrationJobsResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ListSpeakerEnrollmentJobsRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.ListSpeakerEnrollmentJobsResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ListSpeakersRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.ListSpeakersResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.OptOutSpeakerRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.OptOutSpeakerResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.StartFraudsterRegistrationJobRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.StartFraudsterRegistrationJobResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.StartSpeakerEnrollmentJobRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.StartSpeakerEnrollmentJobResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.UpdateDomainRequestProtocolMarshaller;
import com.amazonaws.services.voiceid.model.transform.UpdateDomainResultJsonUnmarshaller;
import com.amazonaws.services.voiceid.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonVoiceIDClient
extends AmazonWebServiceClient
implements AmazonVoiceID {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonVoiceID.class);
    private static final String DEFAULT_SIGNING_NAME = "voiceid";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonVoiceIDException.class));

    public static AmazonVoiceIDClientBuilder builder() {
        return AmazonVoiceIDClientBuilder.standard();
    }

    AmazonVoiceIDClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonVoiceIDClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("voiceid.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/voiceid/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/voiceid/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        request = (CreateDomainRequest)this.beforeClientExecution(request);
        return this.executeCreateDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDomainResult executeCreateDomain(CreateDomainRequest createDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDomainRequestProtocolMarshaller(protocolFactory).marshall((CreateDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDomainResult createDomainResult = (CreateDomainResult)response.getAwsResponse();
            return createDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        request = (DeleteDomainRequest)this.beforeClientExecution(request);
        return this.executeDeleteDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDomainResult executeDeleteDomain(DeleteDomainRequest deleteDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDomainRequestProtocolMarshaller(protocolFactory).marshall((DeleteDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDomainResult deleteDomainResult = (DeleteDomainResult)response.getAwsResponse();
            return deleteDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteFraudsterResult deleteFraudster(DeleteFraudsterRequest request) {
        request = (DeleteFraudsterRequest)this.beforeClientExecution(request);
        return this.executeDeleteFraudster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteFraudsterResult executeDeleteFraudster(DeleteFraudsterRequest deleteFraudsterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteFraudsterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteFraudsterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteFraudsterRequestProtocolMarshaller(protocolFactory).marshall((DeleteFraudsterRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteFraudsterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteFraudster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteFraudsterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteFraudsterResult deleteFraudsterResult = (DeleteFraudsterResult)response.getAwsResponse();
            return deleteFraudsterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSpeakerResult deleteSpeaker(DeleteSpeakerRequest request) {
        request = (DeleteSpeakerRequest)this.beforeClientExecution(request);
        return this.executeDeleteSpeaker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSpeakerResult executeDeleteSpeaker(DeleteSpeakerRequest deleteSpeakerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSpeakerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSpeakerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSpeakerRequestProtocolMarshaller(protocolFactory).marshall((DeleteSpeakerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSpeakerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSpeaker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSpeakerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSpeakerResult deleteSpeakerResult = (DeleteSpeakerResult)response.getAwsResponse();
            return deleteSpeakerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDomainResult describeDomain(DescribeDomainRequest request) {
        request = (DescribeDomainRequest)this.beforeClientExecution(request);
        return this.executeDescribeDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDomainResult executeDescribeDomain(DescribeDomainRequest describeDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDomainRequestProtocolMarshaller(protocolFactory).marshall((DescribeDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDomainResult describeDomainResult = (DescribeDomainResult)response.getAwsResponse();
            return describeDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFraudsterResult describeFraudster(DescribeFraudsterRequest request) {
        request = (DescribeFraudsterRequest)this.beforeClientExecution(request);
        return this.executeDescribeFraudster(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFraudsterResult executeDescribeFraudster(DescribeFraudsterRequest describeFraudsterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFraudsterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFraudsterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFraudsterRequestProtocolMarshaller(protocolFactory).marshall((DescribeFraudsterRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFraudsterRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFraudster");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFraudsterResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFraudsterResult describeFraudsterResult = (DescribeFraudsterResult)response.getAwsResponse();
            return describeFraudsterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeFraudsterRegistrationJobResult describeFraudsterRegistrationJob(DescribeFraudsterRegistrationJobRequest request) {
        request = (DescribeFraudsterRegistrationJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeFraudsterRegistrationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeFraudsterRegistrationJobResult executeDescribeFraudsterRegistrationJob(DescribeFraudsterRegistrationJobRequest describeFraudsterRegistrationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeFraudsterRegistrationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeFraudsterRegistrationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeFraudsterRegistrationJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeFraudsterRegistrationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeFraudsterRegistrationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeFraudsterRegistrationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeFraudsterRegistrationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeFraudsterRegistrationJobResult describeFraudsterRegistrationJobResult = (DescribeFraudsterRegistrationJobResult)response.getAwsResponse();
            return describeFraudsterRegistrationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSpeakerResult describeSpeaker(DescribeSpeakerRequest request) {
        request = (DescribeSpeakerRequest)this.beforeClientExecution(request);
        return this.executeDescribeSpeaker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSpeakerResult executeDescribeSpeaker(DescribeSpeakerRequest describeSpeakerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSpeakerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSpeakerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSpeakerRequestProtocolMarshaller(protocolFactory).marshall((DescribeSpeakerRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSpeakerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSpeaker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSpeakerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSpeakerResult describeSpeakerResult = (DescribeSpeakerResult)response.getAwsResponse();
            return describeSpeakerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSpeakerEnrollmentJobResult describeSpeakerEnrollmentJob(DescribeSpeakerEnrollmentJobRequest request) {
        request = (DescribeSpeakerEnrollmentJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeSpeakerEnrollmentJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSpeakerEnrollmentJobResult executeDescribeSpeakerEnrollmentJob(DescribeSpeakerEnrollmentJobRequest describeSpeakerEnrollmentJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSpeakerEnrollmentJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSpeakerEnrollmentJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSpeakerEnrollmentJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeSpeakerEnrollmentJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSpeakerEnrollmentJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSpeakerEnrollmentJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSpeakerEnrollmentJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSpeakerEnrollmentJobResult describeSpeakerEnrollmentJobResult = (DescribeSpeakerEnrollmentJobResult)response.getAwsResponse();
            return describeSpeakerEnrollmentJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EvaluateSessionResult evaluateSession(EvaluateSessionRequest request) {
        request = (EvaluateSessionRequest)this.beforeClientExecution(request);
        return this.executeEvaluateSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EvaluateSessionResult executeEvaluateSession(EvaluateSessionRequest evaluateSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(evaluateSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EvaluateSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EvaluateSessionRequestProtocolMarshaller(protocolFactory).marshall((EvaluateSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)evaluateSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EvaluateSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EvaluateSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EvaluateSessionResult evaluateSessionResult = (EvaluateSessionResult)response.getAwsResponse();
            return evaluateSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        request = (ListDomainsRequest)this.beforeClientExecution(request);
        return this.executeListDomains(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDomainsResult executeListDomains(ListDomainsRequest listDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDomainsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDomainsRequestProtocolMarshaller(protocolFactory).marshall((ListDomainsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDomainsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDomains");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDomainsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDomainsResult listDomainsResult = (ListDomainsResult)response.getAwsResponse();
            return listDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListFraudsterRegistrationJobsResult listFraudsterRegistrationJobs(ListFraudsterRegistrationJobsRequest request) {
        request = (ListFraudsterRegistrationJobsRequest)this.beforeClientExecution(request);
        return this.executeListFraudsterRegistrationJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListFraudsterRegistrationJobsResult executeListFraudsterRegistrationJobs(ListFraudsterRegistrationJobsRequest listFraudsterRegistrationJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listFraudsterRegistrationJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListFraudsterRegistrationJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListFraudsterRegistrationJobsRequestProtocolMarshaller(protocolFactory).marshall((ListFraudsterRegistrationJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listFraudsterRegistrationJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListFraudsterRegistrationJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListFraudsterRegistrationJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListFraudsterRegistrationJobsResult listFraudsterRegistrationJobsResult = (ListFraudsterRegistrationJobsResult)response.getAwsResponse();
            return listFraudsterRegistrationJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSpeakerEnrollmentJobsResult listSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsRequest request) {
        request = (ListSpeakerEnrollmentJobsRequest)this.beforeClientExecution(request);
        return this.executeListSpeakerEnrollmentJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSpeakerEnrollmentJobsResult executeListSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsRequest listSpeakerEnrollmentJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSpeakerEnrollmentJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSpeakerEnrollmentJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSpeakerEnrollmentJobsRequestProtocolMarshaller(protocolFactory).marshall((ListSpeakerEnrollmentJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSpeakerEnrollmentJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSpeakerEnrollmentJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSpeakerEnrollmentJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSpeakerEnrollmentJobsResult listSpeakerEnrollmentJobsResult = (ListSpeakerEnrollmentJobsResult)response.getAwsResponse();
            return listSpeakerEnrollmentJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSpeakersResult listSpeakers(ListSpeakersRequest request) {
        request = (ListSpeakersRequest)this.beforeClientExecution(request);
        return this.executeListSpeakers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSpeakersResult executeListSpeakers(ListSpeakersRequest listSpeakersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSpeakersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSpeakersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSpeakersRequestProtocolMarshaller(protocolFactory).marshall((ListSpeakersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSpeakersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSpeakers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSpeakersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSpeakersResult listSpeakersResult = (ListSpeakersResult)response.getAwsResponse();
            return listSpeakersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public OptOutSpeakerResult optOutSpeaker(OptOutSpeakerRequest request) {
        request = (OptOutSpeakerRequest)this.beforeClientExecution(request);
        return this.executeOptOutSpeaker(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final OptOutSpeakerResult executeOptOutSpeaker(OptOutSpeakerRequest optOutSpeakerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(optOutSpeakerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<OptOutSpeakerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new OptOutSpeakerRequestProtocolMarshaller(protocolFactory).marshall((OptOutSpeakerRequest)super.beforeMarshalling((AmazonWebServiceRequest)optOutSpeakerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"OptOutSpeaker");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new OptOutSpeakerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            OptOutSpeakerResult optOutSpeakerResult = (OptOutSpeakerResult)response.getAwsResponse();
            return optOutSpeakerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartFraudsterRegistrationJobResult startFraudsterRegistrationJob(StartFraudsterRegistrationJobRequest request) {
        request = (StartFraudsterRegistrationJobRequest)this.beforeClientExecution(request);
        return this.executeStartFraudsterRegistrationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartFraudsterRegistrationJobResult executeStartFraudsterRegistrationJob(StartFraudsterRegistrationJobRequest startFraudsterRegistrationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startFraudsterRegistrationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartFraudsterRegistrationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartFraudsterRegistrationJobRequestProtocolMarshaller(protocolFactory).marshall((StartFraudsterRegistrationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startFraudsterRegistrationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartFraudsterRegistrationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartFraudsterRegistrationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartFraudsterRegistrationJobResult startFraudsterRegistrationJobResult = (StartFraudsterRegistrationJobResult)response.getAwsResponse();
            return startFraudsterRegistrationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartSpeakerEnrollmentJobResult startSpeakerEnrollmentJob(StartSpeakerEnrollmentJobRequest request) {
        request = (StartSpeakerEnrollmentJobRequest)this.beforeClientExecution(request);
        return this.executeStartSpeakerEnrollmentJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartSpeakerEnrollmentJobResult executeStartSpeakerEnrollmentJob(StartSpeakerEnrollmentJobRequest startSpeakerEnrollmentJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startSpeakerEnrollmentJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartSpeakerEnrollmentJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartSpeakerEnrollmentJobRequestProtocolMarshaller(protocolFactory).marshall((StartSpeakerEnrollmentJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startSpeakerEnrollmentJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartSpeakerEnrollmentJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSpeakerEnrollmentJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartSpeakerEnrollmentJobResult startSpeakerEnrollmentJobResult = (StartSpeakerEnrollmentJobResult)response.getAwsResponse();
            return startSpeakerEnrollmentJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDomainResult updateDomain(UpdateDomainRequest request) {
        request = (UpdateDomainRequest)this.beforeClientExecution(request);
        return this.executeUpdateDomain(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDomainResult executeUpdateDomain(UpdateDomainRequest updateDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDomainRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDomainRequestProtocolMarshaller(protocolFactory).marshall((UpdateDomainRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDomainRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Voice ID");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDomain");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDomainResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDomainResult updateDomainResult = (UpdateDomainResult)response.getAwsResponse();
            return updateDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

