/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.IPAddressVersion;
import com.amazonaws.services.wafv2.model.transform.IPSetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IPSet
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String id;
    private String aRN;
    private String description;
    private String iPAddressVersion;
    private List<String> addresses;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public IPSet withName(String name) {
        this.setName(name);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public IPSet withId(String id) {
        this.setId(id);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public IPSet withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public IPSet withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setIPAddressVersion(String iPAddressVersion) {
        this.iPAddressVersion = iPAddressVersion;
    }

    public String getIPAddressVersion() {
        return this.iPAddressVersion;
    }

    public IPSet withIPAddressVersion(String iPAddressVersion) {
        this.setIPAddressVersion(iPAddressVersion);
        return this;
    }

    public IPSet withIPAddressVersion(IPAddressVersion iPAddressVersion) {
        this.iPAddressVersion = iPAddressVersion.toString();
        return this;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Collection<String> addresses) {
        if (addresses == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new ArrayList<String>(addresses);
    }

    public IPSet withAddresses(String ... addresses) {
        if (this.addresses == null) {
            this.setAddresses(new ArrayList<String>(addresses.length));
        }
        for (String ele : addresses) {
            this.addresses.add(ele);
        }
        return this;
    }

    public IPSet withAddresses(Collection<String> addresses) {
        this.setAddresses(addresses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getIPAddressVersion() != null) {
            sb.append("IPAddressVersion: ").append(this.getIPAddressVersion()).append(",");
        }
        if (this.getAddresses() != null) {
            sb.append("Addresses: ").append(this.getAddresses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSet)) {
            return false;
        }
        IPSet other = (IPSet)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIPAddressVersion() == null ^ this.getIPAddressVersion() == null) {
            return false;
        }
        if (other.getIPAddressVersion() != null && !other.getIPAddressVersion().equals(this.getIPAddressVersion())) {
            return false;
        }
        if (other.getAddresses() == null ^ this.getAddresses() == null) {
            return false;
        }
        return other.getAddresses() == null || other.getAddresses().equals(this.getAddresses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIPAddressVersion() == null ? 0 : this.getIPAddressVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAddresses() == null ? 0 : this.getAddresses().hashCode());
        return hashCode;
    }

    public IPSet clone() {
        try {
            return (IPSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

