/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.ManagedRuleSetVersion;
import com.amazonaws.services.wafv2.model.transform.ManagedRuleSetMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ManagedRuleSet
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String id;
    private String aRN;
    private String description;
    private Map<String, ManagedRuleSetVersion> publishedVersions;
    private String recommendedVersion;
    private String labelNamespace;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ManagedRuleSet withName(String name) {
        this.setName(name);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ManagedRuleSet withId(String id) {
        this.setId(id);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public ManagedRuleSet withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ManagedRuleSet withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, ManagedRuleSetVersion> getPublishedVersions() {
        return this.publishedVersions;
    }

    public void setPublishedVersions(Map<String, ManagedRuleSetVersion> publishedVersions) {
        this.publishedVersions = publishedVersions;
    }

    public ManagedRuleSet withPublishedVersions(Map<String, ManagedRuleSetVersion> publishedVersions) {
        this.setPublishedVersions(publishedVersions);
        return this;
    }

    public ManagedRuleSet addPublishedVersionsEntry(String key, ManagedRuleSetVersion value) {
        if (null == this.publishedVersions) {
            this.publishedVersions = new HashMap<String, ManagedRuleSetVersion>();
        }
        if (this.publishedVersions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.publishedVersions.put(key, value);
        return this;
    }

    public ManagedRuleSet clearPublishedVersionsEntries() {
        this.publishedVersions = null;
        return this;
    }

    public void setRecommendedVersion(String recommendedVersion) {
        this.recommendedVersion = recommendedVersion;
    }

    public String getRecommendedVersion() {
        return this.recommendedVersion;
    }

    public ManagedRuleSet withRecommendedVersion(String recommendedVersion) {
        this.setRecommendedVersion(recommendedVersion);
        return this;
    }

    public void setLabelNamespace(String labelNamespace) {
        this.labelNamespace = labelNamespace;
    }

    public String getLabelNamespace() {
        return this.labelNamespace;
    }

    public ManagedRuleSet withLabelNamespace(String labelNamespace) {
        this.setLabelNamespace(labelNamespace);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPublishedVersions() != null) {
            sb.append("PublishedVersions: ").append(this.getPublishedVersions()).append(",");
        }
        if (this.getRecommendedVersion() != null) {
            sb.append("RecommendedVersion: ").append(this.getRecommendedVersion()).append(",");
        }
        if (this.getLabelNamespace() != null) {
            sb.append("LabelNamespace: ").append(this.getLabelNamespace());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRuleSet)) {
            return false;
        }
        ManagedRuleSet other = (ManagedRuleSet)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPublishedVersions() == null ^ this.getPublishedVersions() == null) {
            return false;
        }
        if (other.getPublishedVersions() != null && !other.getPublishedVersions().equals(this.getPublishedVersions())) {
            return false;
        }
        if (other.getRecommendedVersion() == null ^ this.getRecommendedVersion() == null) {
            return false;
        }
        if (other.getRecommendedVersion() != null && !other.getRecommendedVersion().equals(this.getRecommendedVersion())) {
            return false;
        }
        if (other.getLabelNamespace() == null ^ this.getLabelNamespace() == null) {
            return false;
        }
        return other.getLabelNamespace() == null || other.getLabelNamespace().equals(this.getLabelNamespace());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPublishedVersions() == null ? 0 : this.getPublishedVersions().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendedVersion() == null ? 0 : this.getRecommendedVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLabelNamespace() == null ? 0 : this.getLabelNamespace().hashCode());
        return hashCode;
    }

    public ManagedRuleSet clone() {
        try {
            return (ManagedRuleSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ManagedRuleSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

