/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.wafv2.model.MobileSdkRelease;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class MobileSdkReleaseMarshaller {
    private static final MarshallingInfo<String> RELEASEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseVersion").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RELEASENOTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseNotes").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MobileSdkReleaseMarshaller instance = new MobileSdkReleaseMarshaller();

    public static MobileSdkReleaseMarshaller getInstance() {
        return instance;
    }

    public void marshall(MobileSdkRelease mobileSdkRelease, ProtocolMarshaller protocolMarshaller) {
        if (mobileSdkRelease == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mobileSdkRelease.getReleaseVersion(), RELEASEVERSION_BINDING);
            protocolMarshaller.marshall((Object)mobileSdkRelease.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)mobileSdkRelease.getReleaseNotes(), RELEASENOTES_BINDING);
            protocolMarshaller.marshall(mobileSdkRelease.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

