/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmailmessageflow;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.workmailmessageflow.AmazonWorkMailMessageFlowAsync;
import com.amazonaws.services.workmailmessageflow.AmazonWorkMailMessageFlowAsyncClientBuilder;
import com.amazonaws.services.workmailmessageflow.AmazonWorkMailMessageFlowClient;
import com.amazonaws.services.workmailmessageflow.model.GetRawMessageContentRequest;
import com.amazonaws.services.workmailmessageflow.model.GetRawMessageContentResult;
import com.amazonaws.services.workmailmessageflow.model.PutRawMessageContentRequest;
import com.amazonaws.services.workmailmessageflow.model.PutRawMessageContentResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonWorkMailMessageFlowAsyncClient
extends AmazonWorkMailMessageFlowClient
implements AmazonWorkMailMessageFlowAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonWorkMailMessageFlowAsyncClientBuilder asyncBuilder() {
        return AmazonWorkMailMessageFlowAsyncClientBuilder.standard();
    }

    AmazonWorkMailMessageFlowAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonWorkMailMessageFlowAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetRawMessageContentResult> getRawMessageContentAsync(GetRawMessageContentRequest request) {
        return this.getRawMessageContentAsync(request, null);
    }

    @Override
    public Future<GetRawMessageContentResult> getRawMessageContentAsync(GetRawMessageContentRequest request, final AsyncHandler<GetRawMessageContentRequest, GetRawMessageContentResult> asyncHandler) {
        final GetRawMessageContentRequest finalRequest = (GetRawMessageContentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRawMessageContentResult>(){

            @Override
            public GetRawMessageContentResult call() throws Exception {
                GetRawMessageContentResult result = null;
                try {
                    result = AmazonWorkMailMessageFlowAsyncClient.this.executeGetRawMessageContent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRawMessageContentResult> putRawMessageContentAsync(PutRawMessageContentRequest request) {
        return this.putRawMessageContentAsync(request, null);
    }

    @Override
    public Future<PutRawMessageContentResult> putRawMessageContentAsync(PutRawMessageContentRequest request, final AsyncHandler<PutRawMessageContentRequest, PutRawMessageContentResult> asyncHandler) {
        final PutRawMessageContentRequest finalRequest = (PutRawMessageContentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRawMessageContentResult>(){

            @Override
            public PutRawMessageContentResult call() throws Exception {
                PutRawMessageContentResult result = null;
                try {
                    result = AmazonWorkMailMessageFlowAsyncClient.this.executePutRawMessageContent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

