/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspacesweb.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIpAccessSettings"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateIpAccessSettingsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The description of the IP access settings.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The display name of the IP access settings.
     * </p>
     */
    private String displayName;
    /**
     * <p>
     * The ARN of the IP access settings.
     * </p>
     */
    private String ipAccessSettingsArn;
    /**
     * <p>
     * The updated IP rules of the IP access settings.
     * </p>
     */
    private java.util.List<IpRule> ipRules;

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token return the result from the original
     *        successful request. </p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @param clientToken
     *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     *        ensures that an API request completes only once. With an idempotent request, if the original request
     *        completes successfully, subsequent retries with the same client token return the result from the original
     *        successful request. </p>
     *        <p>
     *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateIpAccessSettingsRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The description of the IP access settings.
     * </p>
     * 
     * @param description
     *        The description of the IP access settings.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description of the IP access settings.
     * </p>
     * 
     * @return The description of the IP access settings.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description of the IP access settings.
     * </p>
     * 
     * @param description
     *        The description of the IP access settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateIpAccessSettingsRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The display name of the IP access settings.
     * </p>
     * 
     * @param displayName
     *        The display name of the IP access settings.
     */

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * <p>
     * The display name of the IP access settings.
     * </p>
     * 
     * @return The display name of the IP access settings.
     */

    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * <p>
     * The display name of the IP access settings.
     * </p>
     * 
     * @param displayName
     *        The display name of the IP access settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateIpAccessSettingsRequest withDisplayName(String displayName) {
        setDisplayName(displayName);
        return this;
    }

    /**
     * <p>
     * The ARN of the IP access settings.
     * </p>
     * 
     * @param ipAccessSettingsArn
     *        The ARN of the IP access settings.
     */

    public void setIpAccessSettingsArn(String ipAccessSettingsArn) {
        this.ipAccessSettingsArn = ipAccessSettingsArn;
    }

    /**
     * <p>
     * The ARN of the IP access settings.
     * </p>
     * 
     * @return The ARN of the IP access settings.
     */

    public String getIpAccessSettingsArn() {
        return this.ipAccessSettingsArn;
    }

    /**
     * <p>
     * The ARN of the IP access settings.
     * </p>
     * 
     * @param ipAccessSettingsArn
     *        The ARN of the IP access settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateIpAccessSettingsRequest withIpAccessSettingsArn(String ipAccessSettingsArn) {
        setIpAccessSettingsArn(ipAccessSettingsArn);
        return this;
    }

    /**
     * <p>
     * The updated IP rules of the IP access settings.
     * </p>
     * 
     * @return The updated IP rules of the IP access settings.
     */

    public java.util.List<IpRule> getIpRules() {
        return ipRules;
    }

    /**
     * <p>
     * The updated IP rules of the IP access settings.
     * </p>
     * 
     * @param ipRules
     *        The updated IP rules of the IP access settings.
     */

    public void setIpRules(java.util.Collection<IpRule> ipRules) {
        if (ipRules == null) {
            this.ipRules = null;
            return;
        }

        this.ipRules = new java.util.ArrayList<IpRule>(ipRules);
    }

    /**
     * <p>
     * The updated IP rules of the IP access settings.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setIpRules(java.util.Collection)} or {@link #withIpRules(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param ipRules
     *        The updated IP rules of the IP access settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateIpAccessSettingsRequest withIpRules(IpRule... ipRules) {
        if (this.ipRules == null) {
            setIpRules(new java.util.ArrayList<IpRule>(ipRules.length));
        }
        for (IpRule ele : ipRules) {
            this.ipRules.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The updated IP rules of the IP access settings.
     * </p>
     * 
     * @param ipRules
     *        The updated IP rules of the IP access settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateIpAccessSettingsRequest withIpRules(java.util.Collection<IpRule> ipRules) {
        setIpRules(ipRules);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        if (getDisplayName() != null)
            sb.append("DisplayName: ").append("***Sensitive Data Redacted***").append(",");
        if (getIpAccessSettingsArn() != null)
            sb.append("IpAccessSettingsArn: ").append(getIpAccessSettingsArn()).append(",");
        if (getIpRules() != null)
            sb.append("IpRules: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateIpAccessSettingsRequest == false)
            return false;
        UpdateIpAccessSettingsRequest other = (UpdateIpAccessSettingsRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getDisplayName() == null ^ this.getDisplayName() == null)
            return false;
        if (other.getDisplayName() != null && other.getDisplayName().equals(this.getDisplayName()) == false)
            return false;
        if (other.getIpAccessSettingsArn() == null ^ this.getIpAccessSettingsArn() == null)
            return false;
        if (other.getIpAccessSettingsArn() != null && other.getIpAccessSettingsArn().equals(this.getIpAccessSettingsArn()) == false)
            return false;
        if (other.getIpRules() == null ^ this.getIpRules() == null)
            return false;
        if (other.getIpRules() != null && other.getIpRules().equals(this.getIpRules()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getDisplayName() == null) ? 0 : getDisplayName().hashCode());
        hashCode = prime * hashCode + ((getIpAccessSettingsArn() == null) ? 0 : getIpAccessSettingsArn().hashCode());
        hashCode = prime * hashCode + ((getIpRules() == null) ? 0 : getIpRules().hashCode());
        return hashCode;
    }

    @Override
    public UpdateIpAccessSettingsRequest clone() {
        return (UpdateIpAccessSettingsRequest) super.clone();
    }

}
