/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPaths;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.JournalingUsageTracker;
import com.android.tools.analytics.NullUsageTracker;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ProductDetails;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class UsageTracker
implements AutoCloseable {
    private static final Object sGate = new Object();
    static String sSessionId = UUID.randomUUID().toString();
    public static DateProvider sDateProvider = DateProvider.SYSTEM;
    private static UsageTracker sInstance = new NullUsageTracker(new AnalyticsSettings(), null);
    private final AnalyticsSettings mAnalyticsSettings;
    private final ScheduledExecutorService mScheduler;
    private int mMaxJournalSize;
    private long mMaxJournalTime;
    private String mVersion;
    protected long mStartTimeMs = sDateProvider.now().getTime();

    protected UsageTracker(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler) {
        this.mAnalyticsSettings = analyticsSettings;
        this.mScheduler = scheduler;
    }

    public int getMaxJournalSize() {
        return this.mMaxJournalSize;
    }

    public void setMaxJournalSize(int maxJournalSize) {
        this.mMaxJournalSize = maxJournalSize;
    }

    public long getMaxJournalTime() {
        return this.mMaxJournalTime;
    }

    public void setMaxJournalTime(long duration, TimeUnit unit) {
        this.mMaxJournalTime = unit.toNanos(duration);
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public AnalyticsSettings getAnalyticsSettings() {
        return this.mAnalyticsSettings;
    }

    public ScheduledExecutorService getScheduler() {
        return this.mScheduler;
    }

    public void log(AndroidStudioEvent.Builder studioEvent) {
        this.log(sDateProvider.now().getTime(), studioEvent);
    }

    public void log(long eventTimeMs, AndroidStudioEvent.Builder studioEvent) {
        studioEvent.setStudioSessionId(sSessionId);
        if (this.mVersion != null && !studioEvent.hasProductDetails()) {
            studioEvent.setProductDetails(ProductDetails.newBuilder().setVersion(this.mVersion));
        }
        try {
            this.logDetails(ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(eventTimeMs).setEventUptimeMs(eventTimeMs - this.mStartTimeMs).setSourceExtension(studioEvent.build().toByteString()));
        }
        catch (NullPointerException exception) {
            this.logDetails(ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(eventTimeMs).setEventUptimeMs(eventTimeMs - this.mStartTimeMs));
        }
    }

    public abstract void logDetails(ClientAnalytics.LogEvent.Builder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsageTracker getInstance() {
        Object object = sGate;
        synchronized (object) {
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsageTracker initialize(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler) {
        Object object = sGate;
        synchronized (object) {
            sInstance = analyticsSettings.hasOptedIn() ? new JournalingUsageTracker(analyticsSettings, scheduler, Paths.get(AnalyticsPaths.getSpoolDirectory(), new String[0])) : new NullUsageTracker(analyticsSettings, scheduler);
            return sInstance;
        }
    }

    public static UsageTracker setInstanceForTest(UsageTracker tracker) {
        sInstance = tracker;
        return sInstance;
    }

    public static void cleanAfterTesting() {
        sInstance = new NullUsageTracker(new AnalyticsSettings(), null);
    }

    public static AnalyticsSettings updateSettingsAndTracker(boolean optIn, ILogger logger, ScheduledExecutorService scheduler) {
        UsageTracker current = UsageTracker.getInstance();
        AnalyticsSettings settings = AnalyticsSettings.getInstance((ILogger)logger);
        if (optIn != settings.hasOptedIn()) {
            settings.setHasOptedIn(optIn);
            try {
                settings.saveSettings();
            }
            catch (IOException e) {
                logger.error((Throwable)e, "Unable to save analytics settings", new Object[0]);
            }
        }
        try {
            current.close();
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to close existing analytics tracker", new Object[0]);
        }
        UsageTracker.initialize(settings, scheduler);
        return settings;
    }
}

