/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.dsl.Lint;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.UnsafeOutputsTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.utils.FileUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Internal;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ \u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0018H\u0014J\u001d\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b%R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\u0006R\u001a\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintCopyReportTask;", "Lcom/android/build/gradle/internal/tasks/UnsafeOutputsTask;", "()V", "htmlReportInput", "Lorg/gradle/api/file/RegularFileProperty;", "getHtmlReportInput", "()Lorg/gradle/api/file/RegularFileProperty;", "htmlReportOutput", "getHtmlReportOutput", "sarifReportInput", "getSarifReportInput$annotations", "getSarifReportInput", "sarifReportOutput", "getSarifReportOutput$annotations", "getSarifReportOutput", "textReportInput", "getTextReportInput", "textReportOutput", "getTextReportOutput", "xmlReportInput", "getXmlReportInput", "xmlReportOutput", "getXmlReportOutput", "configureForStandalone", "", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "lintOptions", "Lcom/android/build/api/dsl/Lint;", "configureForStandalone$gradle_core", "doCopy", "from", "to", "displayName", "", "doTaskAction", "registerInputs", "registerInputs$gradle_core", "CreationAction", "gradle-core"})
public abstract class AndroidLintCopyReportTask
extends UnsafeOutputsTask {
    public AndroidLintCopyReportTask() {
        super("The lintOptions DSL has configured potentially multiple lint tasks to write to the same location, but task should not have overlapping outputs.");
    }

    @Internal
    @NotNull
    public abstract RegularFileProperty getTextReportInput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getHtmlReportInput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getXmlReportInput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getSarifReportInput();

    public static /* synthetic */ void getSarifReportInput$annotations() {
    }

    @Internal
    @NotNull
    public abstract RegularFileProperty getTextReportOutput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getHtmlReportOutput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getXmlReportOutput();

    @Internal
    @NotNull
    public abstract RegularFileProperty getSarifReportOutput();

    public static /* synthetic */ void getSarifReportOutput$annotations() {
    }

    @Override
    protected void doTaskAction() {
        this.doCopy(this.getTextReportInput(), this.getTextReportOutput(), "text");
        this.doCopy(this.getHtmlReportInput(), this.getHtmlReportOutput(), "HTML");
        this.doCopy(this.getXmlReportInput(), this.getXmlReportOutput(), "XML");
        this.doCopy(this.getSarifReportInput(), this.getSarifReportOutput(), "SARIF");
    }

    private final void doCopy(RegularFileProperty from, RegularFileProperty to, String displayName) {
        File file;
        File file2;
        Path path;
        RegularFile regularFile = (RegularFile)to.getOrNull();
        Path path2 = regularFile == null ? null : (path = (file2 = regularFile.getAsFile()) == null ? null : file2.toPath());
        if (path == null) {
            return;
        }
        Path toPath = path;
        file2 = (RegularFile)from.getOrNull();
        Path path3 = file2 == null ? null : (regularFile = (file = file2.getAsFile()) == null ? null : file.toPath());
        if (regularFile == null) {
            return;
        }
        RegularFile inputPath = regularFile;
        Logger logger = Logging.getLogger(AndroidLintCopyReportTask.class);
        if (!inputPath.toFile().isFile()) {
            logger.warn("Unable to copy the lint " + displayName + " report because it does not exist. The lint " + displayName + " report file was expected to be located at " + inputPath.toAbsolutePath() + '.');
            return;
        }
        logger.lifecycle("Copying lint " + displayName + " report to " + toPath);
        Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
        FileUtils.copyFile((Path)inputPath, (Path)toPath);
    }

    public final void registerInputs$gradle_core(@NotNull ArtifactsImpl artifacts, @NotNull Lint lintOptions2) {
        Intrinsics.checkNotNullParameter((Object)artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        File textOutput = lintOptions2.getTextOutput();
        if (lintOptions2.getTextReport() && textOutput != null && !Intrinsics.areEqual((Object)textOutput.getPath(), (Object)"stdout") && !Intrinsics.areEqual((Object)textOutput.getPath(), (Object)"stderr")) {
            this.getTextReportInput().set(artifacts.get(InternalArtifactType.LINT_TEXT_REPORT.INSTANCE));
            this.getTextReportOutput().set(textOutput);
        }
        this.getTextReportInput().disallowChanges();
        this.getTextReportOutput().disallowChanges();
        if (lintOptions2.getHtmlReport() && lintOptions2.getHtmlOutput() != null) {
            this.getHtmlReportInput().set(artifacts.get(InternalArtifactType.LINT_HTML_REPORT.INSTANCE));
            this.getHtmlReportOutput().set(lintOptions2.getHtmlOutput());
        }
        this.getHtmlReportInput().disallowChanges();
        this.getHtmlReportOutput().disallowChanges();
        if (lintOptions2.getXmlReport() && lintOptions2.getXmlOutput() != null) {
            this.getXmlReportInput().set(artifacts.get(InternalArtifactType.LINT_XML_REPORT.INSTANCE));
            this.getXmlReportOutput().set(lintOptions2.getXmlOutput());
        }
        this.getXmlReportInput().disallowChanges();
        this.getXmlReportOutput().disallowChanges();
        if (lintOptions2.getSarifReport() && lintOptions2.getSarifOutput() != null) {
            this.getSarifReportInput().set(artifacts.get(InternalArtifactType.LINT_SARIF_REPORT.INSTANCE));
            this.getSarifReportOutput().set(lintOptions2.getSarifOutput());
        }
        this.getSarifReportInput().disallowChanges();
        this.getSarifReportOutput().disallowChanges();
    }

    /*
     * WARNING - void declaration
     */
    public final void configureForStandalone$gradle_core(@NotNull ArtifactsImpl artifacts, @NotNull Lint lintOptions2) {
        void buildServiceRegistry$iv;
        Intrinsics.checkNotNullParameter((Object)artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)lintOptions2, (String)"lintOptions");
        this.registerInputs$gradle_core(artifacts, lintOptions2);
        Property<AnalyticsService> property = this.getAnalyticsService();
        BuildServiceRegistry buildServiceRegistry = this.getProject().getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(AnalyticsService.class));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT of com.android.build.gradle.internal.services.BuildServicesKt.getBuildService, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"buildServiceRegistry.reg\u2026erviceT, *>).getService()");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        this.setVariantName("");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintCopyReportTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintCopyReportTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "variant", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<AndroidLintCopyReportTask, ComponentCreationConfig> {
        @NotNull
        private final String name;

        public CreationAction(@NotNull ComponentCreationConfig variant2) {
            Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
            super(variant2);
            this.name = this.computeTaskName("copy", "AndroidLintReports");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<AndroidLintCopyReportTask> getType() {
            return AndroidLintCopyReportTask.class;
        }

        @Override
        public void configure(@NotNull AndroidLintCopyReportTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.registerInputs$gradle_core(this.creationConfig.getArtifacts(), this.creationConfig.getGlobal().getLintOptions());
        }
    }
}

