/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.AllTestResults;
import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.CodePanelRenderer;
import com.android.build.gradle.internal.test.report.ErroringAction;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.SimpleHtmlWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.gradle.api.Action;

class OverviewPageRenderer
extends PageRenderer<AllTestResults> {
    private final CodePanelRenderer codePanelRenderer = new CodePanelRenderer();

    public OverviewPageRenderer(ReportType reportType) {
        super(reportType);
    }

    @Override
    protected void registerTabs() {
        this.addToolFailuresTab();
        this.addFailuresTab();
        if (!((AllTestResults)this.getResults()).getPackages().isEmpty()) {
            this.addTab("Packages", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                protected void doExecute(SimpleHtmlWriter writer) throws IOException {
                    OverviewPageRenderer.this.renderPackages(writer);
                }
            });
        }
        this.addTab("Classes", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            @Override
            public void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                OverviewPageRenderer.this.renderClasses(htmlWriter);
            }
        });
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) {
    }

    private void renderPackages(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thead");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters("Package").endElement();
        htmlWriter.startElement("th").characters("Tests").endElement();
        htmlWriter.startElement("th").characters("Failures").endElement();
        htmlWriter.startElement("th").characters("Duration").endElement();
        htmlWriter.startElement("th").characters("Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        htmlWriter.startElement("tbody");
        for (PackageTestResults testPackage : ((AllTestResults)this.getResults()).getPackages()) {
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td").attribute("class", testPackage.getStatusClass());
            htmlWriter.startElement("a").attribute("href", String.format("%s.html", testPackage.getFilename(this.reportType))).characters(testPackage.getName()).endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td").characters(Integer.toString(testPackage.getTestCount())).endElement();
            htmlWriter.startElement("td").characters(Integer.toString(testPackage.getFailureCount())).endElement();
            htmlWriter.startElement("td").characters(testPackage.getFormattedDuration()).endElement();
            htmlWriter.startElement("td").attribute("class", testPackage.getStatusClass()).characters(testPackage.getFormattedSuccessRate()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
        htmlWriter.endElement();
    }

    private void renderClasses(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thead");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters("Class").endElement();
        htmlWriter.startElement("th").characters("Tests").endElement();
        htmlWriter.startElement("th").characters("Failures").endElement();
        htmlWriter.startElement("th").characters("Duration").endElement();
        htmlWriter.startElement("th").characters("Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        htmlWriter.startElement("tbody");
        for (PackageTestResults testPackage : ((AllTestResults)this.getResults()).getPackages()) {
            for (ClassTestResults testClass : testPackage.getClasses()) {
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).endElement();
                htmlWriter.startElement("a").attribute("href", String.format("%s.html", testClass.getFilename(this.reportType))).characters(testClass.getName()).endElement();
                htmlWriter.startElement("td").characters(Integer.toString(testClass.getTestCount())).endElement();
                htmlWriter.startElement("td").characters(Integer.toString(testClass.getFailureCount())).endElement();
                htmlWriter.startElement("td").characters(testClass.getFormattedDuration()).endElement();
                htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).characters(testClass.getFormattedSuccessRate()).endElement();
                htmlWriter.endElement();
            }
        }
        htmlWriter.endElement();
        htmlWriter.endElement();
    }

    private void addToolFailuresTab() {
        final List standardErrorPerDevices = ((AllTestResults)this.getResults()).getStandardErrorPerDevices().entrySet().stream().filter(entry -> !StringsKt.isBlank((CharSequence)((CharSequence)entry.getValue()))).collect(Collectors.toList());
        if (!standardErrorPerDevices.isEmpty()) {
            this.addTab("Tool failures", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                public void doExecute(SimpleHtmlWriter writer) throws IOException {
                    for (Map.Entry entry : standardErrorPerDevices) {
                        writer.startElement("h2").characters((CharSequence)entry.getKey()).endElement();
                        OverviewPageRenderer.this.codePanelRenderer.render(((StringBuilder)entry.getValue()).toString(), writer);
                    }
                }
            });
        }
    }
}

