/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.api.component.impl;

import com.android.build.api.variant.AndroidVersion;
import com.android.build.api.variant.Renderscript;
import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.component.ConsumableCreationConfig;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.services.VariantServices;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/android/build/api/component/impl/ConsumableCreationConfigImpl;", "T", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "", "config", "variantDslInfo", "Lcom/android/build/gradle/internal/core/VariantDslInfo;", "(Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;Lcom/android/build/gradle/internal/core/VariantDslInfo;)V", "getConfig", "()Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "Lcom/android/build/gradle/internal/component/ConsumableCreationConfig;", "dexingType", "Lcom/android/builder/dexing/DexingType;", "getDexingType", "()Lcom/android/builder/dexing/DexingType;", "isCoreLibraryDesugaringEnabled", "", "()Z", "minSdkVersionForDexing", "Lcom/android/build/api/variant/AndroidVersion;", "getMinSdkVersionForDexing", "()Lcom/android/build/api/variant/AndroidVersion;", "needsShrinkDesugarLibrary", "getNeedsShrinkDesugarLibrary", "getVariantDslInfo", "()Lcom/android/build/gradle/internal/core/VariantDslInfo;", "getJava8LangSupportType", "Lcom/android/build/gradle/internal/scope/VariantScope$Java8LangSupport;", "getNeedsMergedJavaResStream", "creationConfig", "renderscript", "Lcom/android/build/api/variant/Renderscript;", "internalServices", "Lcom/android/build/gradle/internal/services/VariantServices;", "gradle-core"})
public class ConsumableCreationConfigImpl<T extends ConsumableCreationConfig> {
    @NotNull
    private final T config;
    @NotNull
    private final VariantDslInfo variantDslInfo;

    public ConsumableCreationConfigImpl(@NotNull T config2, @NotNull VariantDslInfo variantDslInfo) {
        Intrinsics.checkNotNullParameter(config2, (String)"config");
        Intrinsics.checkNotNullParameter((Object)variantDslInfo, (String)"variantDslInfo");
        this.config = config2;
        this.variantDslInfo = variantDslInfo;
    }

    @NotNull
    public final T getConfig() {
        return this.config;
    }

    @NotNull
    public final VariantDslInfo getVariantDslInfo() {
        return this.variantDslInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final DexingType getDexingType() {
        DexingType dexingType;
        DexingType dexingType2 = this.variantDslInfo.getDexingType();
        if (dexingType2 != null) {
            dexingType = dexingType2;
            return dexingType;
        }
        if (!this.config.isMultiDexEnabled()) {
            dexingType = DexingType.MONO_DEX;
            return dexingType;
        }
        if (VariantApiExtensionsKt.getFeatureLevel(this.config.getMinSdkVersion()) < 21) {
            boolean bl;
            Integer n = this.variantDslInfo.getTargetDeployApiFromIDE();
            if (n == null) {
                bl = false;
            } else {
                Integer n2 = n;
                boolean bl2 = false;
                boolean bl3 = false;
                int it = ((Number)n2).intValue();
                boolean bl4 = false;
                bl = it >= 21;
            }
            if (!bl) {
                dexingType = DexingType.LEGACY_MULTIDEX;
                return dexingType;
            }
        }
        dexingType = DexingType.NATIVE_MULTIDEX;
        return dexingType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getNeedsMergedJavaResStream() {
        if (this.variantDslInfo.getComponentType().isAar()) return true;
        Collection collection = this.variantDslInfo.getTransforms();
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!this.config.getMinifiedEnabled()) return false;
        return true;
    }

    @NotNull
    public VariantScope.Java8LangSupport getJava8LangSupportType() {
        return !this.variantDslInfo.getCompileOptions().getTargetCompatibility().isJava8Compatible() ? VariantScope.Java8LangSupport.UNUSED : (this.config.getServices().getProjectInfo().hasPlugin("me.tatarka.retrolambda") ? VariantScope.Java8LangSupport.RETROLAMBDA : (this.config.getMinifiedEnabled() ? VariantScope.Java8LangSupport.R8 : VariantScope.Java8LangSupport.D8));
    }

    public final boolean isCoreLibraryDesugaringEnabled() {
        return this.isCoreLibraryDesugaringEnabled((ConsumableCreationConfig)this.config);
    }

    public boolean getNeedsShrinkDesugarLibrary() {
        return this.isCoreLibraryDesugaringEnabled((ConsumableCreationConfig)this.config);
    }

    public final boolean isCoreLibraryDesugaringEnabled(@NotNull ConsumableCreationConfig creationConfig) {
        boolean langDesugarEnabled;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        boolean libDesugarEnabled = this.variantDslInfo.getCompileOptions().isCoreLibraryDesugaringEnabled();
        boolean multidexEnabled = creationConfig.isMultiDexEnabled();
        VariantScope.Java8LangSupport langSupportType = this.getJava8LangSupportType();
        boolean bl = langDesugarEnabled = langSupportType == VariantScope.Java8LangSupport.D8 || langSupportType == VariantScope.Java8LangSupport.R8;
        if (libDesugarEnabled && !langDesugarEnabled) {
            IssueReporter.reportError$default((IssueReporter)this.config.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to use core library desugaring, please enable java 8 language desugaring with D8 or R8.", null, null, (int)12, null);
        }
        if (libDesugarEnabled && !multidexEnabled) {
            IssueReporter.reportError$default((IssueReporter)this.config.getServices().getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to use core library desugaring, please enable multidex.", null, null, (int)12, null);
        }
        return libDesugarEnabled;
    }

    @NotNull
    public AndroidVersion getMinSdkVersionForDexing() {
        return this.config.getMinSdkVersion();
    }

    @Nullable
    public final Renderscript renderscript(@NotNull VariantServices internalServices) {
        Renderscript renderscript2;
        Intrinsics.checkNotNullParameter((Object)internalServices, (String)"internalServices");
        if (this.config.getBuildFeatures().getRenderScript()) {
            Renderscript renderscript3 = internalServices.newInstance(Renderscript.class, new Object[0]);
            boolean bl = false;
            boolean bl2 = false;
            Renderscript it = renderscript3;
            boolean bl3 = false;
            it.getSupportModeEnabled().set((Object)this.getVariantDslInfo().getRenderscriptSupportModeEnabled());
            it.getSupportModeBlasEnabled().set((Object)this.getVariantDslInfo().getRenderscriptSupportModeBlasEnabled());
            it.getNdkModeEnabled().set((Object)this.getVariantDslInfo().getRenderscriptNdkModeEnabled());
            it.getOptimLevel().set((Object)this.getVariantDslInfo().getRenderscriptOptimLevel());
            renderscript2 = renderscript3;
        } else {
            renderscript2 = null;
        }
        return renderscript2;
    }
}

