/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.dependency.JacocoInstrumentationService;
import com.android.build.gradle.internal.tasks.JacocoTask;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.ide.common.resources.FileStatus;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/dependency/JacocoTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/JacocoTransform$Params;", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "inputChanges", "Lorg/gradle/work/InputChanges;", "getInputChanges", "()Lorg/gradle/work/InputChanges;", "cleanTransformOutputFile", "", "relativeFile", "Lcom/android/builder/files/RelativeFile;", "classesOutputPath", "Ljava/nio/file/Path;", "getInstrumentationAction", "Lcom/android/build/gradle/internal/tasks/JacocoTask$Action;", "relativePath", "", "instrumentFile", "sourceFile", "outputDir", "Ljava/io/File;", "instrumentJar", "inputJar", "outputJar", "isJarFile", "", "candidateFile", "transform", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "transformDirectory", "rootDir", "changes", "Lcom/android/builder/files/SerializableFileChanges;", "Params", "gradle-core"})
public abstract class JacocoTransform
implements TransformAction<Params> {
    @Inject
    @NotNull
    public abstract InputChanges getInputChanges();

    @InputArtifact
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Incremental
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs transformOutputs) {
        Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
        File inputArtifactFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)inputArtifactFile, (String)"inputArtifactFile");
        if (this.isJarFile(inputArtifactFile)) {
            File outputFile = transformOutputs.file((Object)Intrinsics.stringPlus((String)"instrumented_", (Object)inputArtifactFile.getName()));
            Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
            this.instrumentJar(inputArtifactFile, outputFile);
        } else {
            Iterable iterable = this.getInputChanges().getFileChanges(this.getInputArtifact());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(inputArtifact)");
            SerializableFileChanges changes = IncrementalChangesUtils.toSerializable(iterable);
            this.transformDirectory(inputArtifactFile, changes, transformOutputs);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transformDirectory(File rootDir, SerializableFileChanges changes, TransformOutputs transformOutputs) {
        void $this$filterTo$iv$iv;
        if (!rootDir.isDirectory()) {
            throw new IOException(rootDir + " must be a directory.");
        }
        File classOutputDir = transformOutputs.dir((Object)"instrumented_classes");
        Iterable $this$filter$iv = changes.getFileChanges();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SerializableChange it = (SerializableChange)element$iv$iv;
            boolean bl = false;
            if (!it.getFile().isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fileChanges = (List)destination$iv$iv;
        for (SerializableChange change : fileChanges) {
            RelativeFile relativeFileChange = RelativeFile.fileInDirectory((String)StringsKt.replace$default((String)change.getNormalizedPath(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), (File)change.getFile());
            if (change.getFileStatus() == FileStatus.NEW || change.getFileStatus() == FileStatus.CHANGED) {
                Intrinsics.checkNotNullExpressionValue((Object)relativeFileChange, (String)"relativeFileChange");
                Intrinsics.checkNotNullExpressionValue((Object)classOutputDir, (String)"classOutputDir");
                this.instrumentFile(relativeFileChange, classOutputDir);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)relativeFileChange, (String)"relativeFileChange");
            Path path = classOutputDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"classOutputDir.toPath()");
            this.cleanTransformOutputFile(relativeFileChange, path);
        }
    }

    private final void cleanTransformOutputFile(RelativeFile relativeFile, Path classesOutputPath) {
        String string = relativeFile.getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"relativeFile.relativePath");
        if (this.getInstrumentationAction(string) == JacocoTask.Action.IGNORE) {
            return;
        }
        String[] stringArray = new String[]{relativeFile.getRelativePath()};
        File fileToRemove = FileUtils.join((File)classesOutputPath.toFile(), (String[])stringArray);
        FileUtils.deleteIfExists((File)fileToRemove);
    }

    private final boolean isJarFile(File candidateFile) {
        return candidateFile.isFile() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)candidateFile), (Object)"jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentJar(File inputJar, File outputJar) {
        try {
            Closeable closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputJar)));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ZipOutputStream instrumentedJar = (ZipOutputStream)closeable;
                boolean bl3 = false;
                Closeable closeable2 = new ZipFile(inputJar);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    ZipFile zip = (ZipFile)closeable2;
                    boolean bl6 = false;
                    Enumeration<? extends ZipEntry> entries2 = zip.entries();
                    block17: while (entries2.hasMoreElements()) {
                        byte[] byArray;
                        ZipEntry entry = entries2.nextElement();
                        String entryName = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)entryName, (String)"entryName");
                        JacocoTask.Action action = this.getInstrumentationAction(entryName);
                        int n = WhenMappings.$EnumSwitchMapping$0[action.ordinal()];
                        switch (n) {
                            case 1: {
                                continue block17;
                            }
                            case 2: {
                                byArray = ByteStreams.toByteArray((InputStream)zip.getInputStream(entry));
                                break;
                            }
                            case 3: {
                                JacocoInstrumentationService jacocoInstrumentationService = (JacocoInstrumentationService)((Params)this.getParameters()).getJacocoInstrumentationService().get();
                                Object object = zip.getInputStream(entry);
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"zip.getInputStream(entry)");
                                InputStream inputStream = object;
                                Iterable iterable = (Iterable)((Params)this.getParameters()).getJacocoConfiguration();
                                object = ((Params)this.getParameters()).getJacocoVersion().get();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.jacocoVersion.get()");
                                byArray = jacocoInstrumentationService.instrument(inputStream, entryName, iterable, (String)object);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        byte[] data = byArray;
                        ZipEntry nextEntry = new ZipEntry(entryName);
                        nextEntry.setTime(-1L);
                        instrumentedJar.putNextEntry(nextEntry);
                        instrumentedJar.write(data);
                        instrumentedJar.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(Intrinsics.stringPlus((String)"Unable to instrument file with Jacoco: ", (Object)inputJar), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void instrumentFile(RelativeFile sourceFile, File outputDir) {
        JacocoTask.Action instrumentationAction = this.getInstrumentationAction(sourceFile);
        if (instrumentationAction == JacocoTask.Action.IGNORE) {
            return;
        }
        Object object = sourceFile.getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceFile.relativePath");
        File outputFile = FilesKt.resolve((File)outputDir, (String)object);
        if (!outputFile.exists()) {
            Files.createParentDirs((File)outputFile);
        }
        if (instrumentationAction == JacocoTask.Action.INSTRUMENT) {
            byte[] byArray;
            object = sourceFile.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sourceFile.file");
            boolean bl = false;
            object = new FileInputStream((File)object);
            File file = outputFile;
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)object;
                boolean bl3 = false;
                JacocoInstrumentationService jacocoInstrumentationService = (JacocoInstrumentationService)((Params)this.getParameters()).getJacocoInstrumentationService().get();
                InputStream inputStream = it;
                Object object2 = sourceFile.getRelativePath();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"sourceFile.relativePath");
                String string = object2;
                Iterable iterable = (Iterable)((Params)this.getParameters()).getJacocoConfiguration();
                object2 = ((Params)this.getParameters()).getJacocoVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.jacocoVersion.get()");
                byArray = jacocoInstrumentationService.instrument(inputStream, string, iterable, (String)object2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            byte[] byArray2 = byArray;
            FilesKt.writeBytes((File)file, (byte[])byArray2);
        } else {
            FileUtils.copyFile((File)sourceFile.getFile(), (File)outputFile);
        }
    }

    @NotNull
    public final JacocoTask.Action getInstrumentationAction(@NotNull RelativeFile relativeFile) {
        Intrinsics.checkNotNullParameter((Object)relativeFile, (String)"relativeFile");
        String string = relativeFile.getRelativePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"relativeFile.relativePath");
        return this.getInstrumentationAction(string);
    }

    @NotNull
    public final JacocoTask.Action getInstrumentationAction(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return JacocoTask.Companion.calculateAction(relativePath);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/dependency/JacocoTransform$Params;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "()V", "jacocoConfiguration", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getJacocoConfiguration", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "jacocoInstrumentationService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/dependency/JacocoInstrumentationService;", "getJacocoInstrumentationService", "()Lorg/gradle/api/provider/Property;", "jacocoVersion", "", "getJacocoVersion", "gradle-core"})
    public static abstract class Params
    implements GenericTransformParameters {
        @Internal
        @NotNull
        public abstract Property<String> getJacocoVersion();

        @Classpath
        @NotNull
        public abstract ConfigurableFileCollection getJacocoConfiguration();

        @Internal
        @NotNull
        public abstract Property<JacocoInstrumentationService> getJacocoInstrumentationService();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JacocoTask.Action.values().length];
            nArray[JacocoTask.Action.IGNORE.ordinal()] = 1;
            nArray[JacocoTask.Action.COPY.ordinal()] = 2;
            nArray[JacocoTask.Action.INSTRUMENT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

