/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.manifest;

import com.android.build.gradle.internal.manifest.ManifestData;
import com.android.builder.errors.IssueReporter;
import com.android.utils.XmlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"PARSER_FACTORY", "Ljavax/xml/parsers/SAXParserFactory;", "kotlin.jvm.PlatformType", "parseManifest", "Lcom/android/build/gradle/internal/manifest/ManifestData;", "file", "Ljava/io/File;", "manifestFileRequired", "", "manifestParsingAllowed", "Ljava/util/function/BooleanSupplier;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "toAndroidTarget", "Lcom/android/build/gradle/internal/manifest/ManifestData$AndroidTarget;", "", "gradle-core"})
public final class ManifestDataKt {
    private static final SAXParserFactory PARSER_FACTORY;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ManifestData parseManifest(@NotNull File file, boolean manifestFileRequired, @NotNull BooleanSupplier manifestParsingAllowed, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manifestParsingAllowed, (String)"manifestParsingAllowed");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        if (!manifestParsingAllowed.getAsBoolean()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"currentThread().stackTrace");
            Object $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toString();
                collection.add(string);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!(!StringsKt.startsWith$default((String)it, (String)"com.android.build.gradle.internal.manifest.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)"org.gradle.", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List stackTrace = ((List)destination$iv$iv).subList(1, 10);
            String stackTraceString = CollectionsKt.joinToString$default((Iterable)stackTrace, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.MANIFEST_PARSED_DURING_CONFIGURATION, (String)Intrinsics.stringPlus((String)"The manifest is being parsed during configuration. Please either remove android.disableConfigurationManifestParsing from build.gradle or remove any build configuration rules that read the android manifest file.\n", (Object)stackTraceString), null, null, (int)12, null);
        }
        ManifestData data = new ManifestData(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
        if (!file.exists()) {
            if (manifestFileRequired) {
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.MISSING_ANDROID_MANIFEST, (String)Intrinsics.stringPlus((String)"Manifest file does not exist: ", (Object)file.getAbsolutePath()), null, null, (int)12, null);
                data.setPackageName("fake.package.name.for.sync");
            }
            return data;
        }
        DefaultHandler handler2 = new DefaultHandler(data){
            final /* synthetic */ ManifestData $data;
            {
                this.$data = $data;
            }

            public void startElement(@Nullable String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes2) throws SAXException {
                Intrinsics.checkNotNullParameter((Object)localName, (String)"localName");
                Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
                Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
                CharSequence charSequence = uri;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    if (Intrinsics.areEqual((Object)"manifest", (Object)localName)) {
                        Integer n;
                        this.$data.setSplit(attributes2.getValue("", "split"));
                        this.$data.setPackageName(attributes2.getValue("", "package"));
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "versionCode");
                        if (charSequence == null) {
                            n = null;
                        } else {
                            CharSequence charSequence2 = charSequence;
                            bl2 = false;
                            n = Integer.parseInt((String)charSequence2);
                        }
                        this.$data.setVersionCode(n);
                        this.$data.setVersionName(attributes2.getValue("http://schemas.android.com/apk/res/android", "versionName"));
                    } else if (Intrinsics.areEqual((Object)"instrumentation", (Object)localName)) {
                        Boolean bl3;
                        Boolean bl4;
                        this.$data.setTestLabel(attributes2.getValue("http://schemas.android.com/apk/res/android", "label"));
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "functionalTest");
                        if (charSequence == null) {
                            bl4 = null;
                        } else {
                            CharSequence charSequence3 = charSequence;
                            bl2 = false;
                            bl4 = Boolean.parseBoolean((String)charSequence3);
                        }
                        this.$data.setFunctionalTest(bl4);
                        this.$data.setInstrumentationRunner(attributes2.getValue("http://schemas.android.com/apk/res/android", "name"));
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "handleProfiling");
                        if (charSequence == null) {
                            bl3 = null;
                        } else {
                            CharSequence charSequence4 = charSequence;
                            bl2 = false;
                            bl3 = Boolean.parseBoolean((String)charSequence4);
                        }
                        this.$data.setHandleProfiling(bl3);
                    } else if (Intrinsics.areEqual((Object)"uses-sdk", (Object)localName)) {
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "minSdkVersion");
                        this.$data.setMinSdkVersion(charSequence == null ? null : ManifestDataKt.access$toAndroidTarget((String)charSequence));
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "targetSdkVersion");
                        this.$data.setTargetSdkVersion(charSequence == null ? null : ManifestDataKt.access$toAndroidTarget((String)charSequence));
                    } else if (Intrinsics.areEqual((Object)"application", (Object)localName)) {
                        Boolean bl5;
                        Boolean bl6;
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "extractNativeLibs");
                        if (charSequence == null) {
                            bl6 = null;
                        } else {
                            CharSequence charSequence5 = charSequence;
                            bl2 = false;
                            bl6 = Boolean.parseBoolean((String)charSequence5);
                        }
                        this.$data.setExtractNativeLibs(bl6);
                        charSequence = attributes2.getValue("http://schemas.android.com/apk/res/android", "useEmbeddedDex");
                        if (charSequence == null) {
                            bl5 = null;
                        } else {
                            CharSequence charSequence6 = charSequence;
                            bl2 = false;
                            bl5 = Boolean.parseBoolean((String)charSequence6);
                        }
                        this.$data.setUseEmbeddedDex(bl5);
                    }
                }
            }
        };
        try {
            SAXParser saxParser = XmlUtils.createSaxParser((SAXParserFactory)PARSER_FACTORY);
            saxParser.parse(file, handler2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    private static final ManifestData.AndroidTarget toAndroidTarget(String $this$toAndroidTarget) {
        ManifestData.AndroidTarget androidTarget;
        try {
            Integer apiLevel = Integer.valueOf($this$toAndroidTarget);
            androidTarget = new ManifestData.AndroidTarget(apiLevel, null);
        }
        catch (NumberFormatException ignored) {
            androidTarget = new ManifestData.AndroidTarget(null, $this$toAndroidTarget);
        }
        return androidTarget;
    }

    public static final /* synthetic */ ManifestData.AndroidTarget access$toAndroidTarget(String $receiver) {
        return ManifestDataKt.toAndroidTarget($receiver);
    }

    static {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null);
        boolean bl = false;
        boolean bl2 = false;
        SAXParserFactory it = sAXParserFactory;
        boolean bl3 = false;
        XmlUtils.configureSaxFactory((SAXParserFactory)it, (boolean)true, (boolean)false);
        PARSER_FACTORY = sAXParserFactory;
    }
}

