/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.tasks.ListingFileRedirectTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.VariantAwareTaskKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.ide.common.build.ListingFileRedirect;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0015R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/tasks/ListingFileRedirectTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "listingFile", "Lorg/gradle/api/file/RegularFileProperty;", "getListingFile", "()Lorg/gradle/api/file/RegularFileProperty;", "redirectFile", "getRedirectFile", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class ListingFileRedirectTask
extends NonIncrementalTask {
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getRedirectFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getListingFile();

    @Override
    @TaskAction
    protected void doTaskAction() {
        Object object = this.getListingFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"listingFile.asFile.get()");
        File file = (File)object;
        object = this.getRedirectFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"redirectFile.asFile.get()");
        ListingFileRedirect.INSTANCE.writeRedirect(file, (File)object);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/ListingFileRedirectTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ListingFileRedirectTask;", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "taskSuffix", "", "inputArtifactType", "Lcom/android/build/api/artifact/Artifact$Single;", "Lorg/gradle/api/file/RegularFile;", "outputArtifactType", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;Ljava/lang/String;Lcom/android/build/api/artifact/Artifact$Single;Lcom/android/build/api/artifact/Artifact$Single;)V", "name", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends TaskCreationAction<ListingFileRedirectTask> {
        @NotNull
        private final ComponentCreationConfig creationConfig;
        @NotNull
        private final Artifact.Single<RegularFile> inputArtifactType;
        @NotNull
        private final Artifact.Single<RegularFile> outputArtifactType;
        @NotNull
        private final Class<ListingFileRedirectTask> type;
        @NotNull
        private final String name;

        public CreationAction(@NotNull ComponentCreationConfig creationConfig, @NotNull String taskSuffix, @NotNull Artifact.Single<RegularFile> inputArtifactType, @NotNull Artifact.Single<RegularFile> outputArtifactType) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)taskSuffix, (String)"taskSuffix");
            Intrinsics.checkNotNullParameter(inputArtifactType, (String)"inputArtifactType");
            Intrinsics.checkNotNullParameter(outputArtifactType, (String)"outputArtifactType");
            this.creationConfig = creationConfig;
            this.inputArtifactType = inputArtifactType;
            this.outputArtifactType = outputArtifactType;
            this.type = ListingFileRedirectTask.class;
            this.name = this.creationConfig.computeTaskName("create", Intrinsics.stringPlus((String)taskSuffix, (Object)"ListingFileRedirect"));
        }

        @Override
        @NotNull
        public Class<ListingFileRedirectTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ListingFileRedirectTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("redirect.txt").on(this.outputArtifactType);
        }

        @Override
        public void configure(@NotNull ListingFileRedirectTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            VariantAwareTaskKt.configureVariantProperties(task, "", this.creationConfig.getServices().getBuildServiceRegistry());
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getListingFile(), this.creationConfig.getArtifacts().get(this.inputArtifactType));
        }
    }
}

