/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.api.dsl.ApkSigningConfig;
import com.android.build.api.dsl.DefaultConfig;
import com.android.build.api.dsl.ProductFlavor;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.VariantDslInfoBuilder;
import com.android.build.gradle.internal.dependency.SourceSetManager;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.plugins.DslContainerProvider;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.builder.core.ComponentType;
import com.android.builder.core.ComponentTypeImpl;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 )*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\t2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\n:\u0001)B\u001d\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00028\u0003H\u0004\u00a2\u0006\u0002\u0010(R&\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00150\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u00190\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00028\u00030\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/variant/AbstractVariantInputManager;", "DefaultConfigT", "Lcom/android/build/api/dsl/DefaultConfig;", "BuildTypeT", "Lcom/android/build/api/dsl/BuildType;", "ProductFlavorT", "Lcom/android/build/api/dsl/ProductFlavor;", "SigningConfigT", "Lcom/android/build/api/dsl/ApkSigningConfig;", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "Lcom/android/build/gradle/internal/plugins/DslContainerProvider;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "componentType", "Lcom/android/builder/core/ComponentType;", "sourceSetManager", "Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "(Lcom/android/build/gradle/internal/services/DslServices;Lcom/android/builder/core/ComponentType;Lcom/android/build/gradle/internal/dependency/SourceSetManager;)V", "buildTypes", "", "", "Lcom/android/build/gradle/internal/BuildTypeData;", "getBuildTypes", "()Ljava/util/Map;", "productFlavors", "Lcom/android/build/gradle/internal/ProductFlavorData;", "getProductFlavors", "signingConfigs", "getSigningConfigs", "getSourceSetManager", "()Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "addBuildType", "", "buildType", "(Lcom/android/build/api/dsl/BuildType;)V", "addProductFlavor", "productFlavor", "(Lcom/android/build/api/dsl/ProductFlavor;)V", "addSigningConfig", "signingConfig", "(Lcom/android/build/api/dsl/ApkSigningConfig;)V", "Companion", "gradle-core"})
public abstract class AbstractVariantInputManager<DefaultConfigT extends DefaultConfig, BuildTypeT extends com.android.build.api.dsl.BuildType, ProductFlavorT extends ProductFlavor, SigningConfigT extends ApkSigningConfig>
implements VariantInputModel<DefaultConfigT, BuildTypeT, ProductFlavorT, SigningConfigT>,
DslContainerProvider<DefaultConfigT, BuildTypeT, ProductFlavorT, SigningConfigT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DslServices dslServices;
    @NotNull
    private final ComponentType componentType;
    @NotNull
    private final SourceSetManager sourceSetManager;
    @NotNull
    private final Map<String, BuildTypeData<BuildTypeT>> buildTypes;
    @NotNull
    private final Map<String, ProductFlavorData<ProductFlavorT>> productFlavors;
    @NotNull
    private final Map<String, SigningConfigT> signingConfigs;

    public AbstractVariantInputManager(@NotNull DslServices dslServices2, @NotNull ComponentType componentType, @NotNull SourceSetManager sourceSetManager) {
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)sourceSetManager, (String)"sourceSetManager");
        this.dslServices = dslServices2;
        this.componentType = componentType;
        this.sourceSetManager = sourceSetManager;
        boolean bl = false;
        this.buildTypes = new LinkedHashMap();
        bl = false;
        this.productFlavors = new LinkedHashMap();
        bl = false;
        this.signingConfigs = new LinkedHashMap();
    }

    @Override
    @NotNull
    public SourceSetManager getSourceSetManager() {
        return this.sourceSetManager;
    }

    @Override
    @NotNull
    public Map<String, BuildTypeData<BuildTypeT>> getBuildTypes() {
        return this.buildTypes;
    }

    @Override
    @NotNull
    public Map<String, ProductFlavorData<ProductFlavorT>> getProductFlavors() {
        return this.productFlavors;
    }

    @Override
    @NotNull
    public Map<String, SigningConfigT> getSigningConfigs() {
        return this.signingConfigs;
    }

    protected final void addSigningConfig(@NotNull SigningConfigT signingConfig2) {
        Intrinsics.checkNotNullParameter(signingConfig2, (String)"signingConfig");
        Map<String, SigningConfigT> map = this.getSigningConfigs();
        String string = signingConfig2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signingConfig.name");
        boolean bl = false;
        map.put(string, signingConfig2);
    }

    protected final void addBuildType(@NotNull BuildTypeT buildType) {
        Intrinsics.checkNotNullParameter(buildType, (String)"buildType");
        String name = buildType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        AbstractVariantInputManager.Companion.checkName(name, "BuildType");
        if (this.getProductFlavors().containsKey(name)) {
            throw new RuntimeException("BuildType names cannot collide with ProductFlavor names");
        }
        if (buildType instanceof BuildType) {
            if (this.componentType.isDynamicFeature()) {
                ((BuildType)buildType).init();
            } else {
                Object object = this.getSigningConfigContainer().findByName("debug");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.SigningConfig");
                }
                ((BuildType)buildType).init((SigningConfig)object);
            }
        } else {
            throw new RuntimeException("Unexpected instance of BuildTypeT");
        }
        DefaultAndroidSourceSet androidTestSourceSet = this.componentType.getHasTestComponents() ? (DefaultAndroidSourceSet)this.getSourceSetManager().setUpTestSourceSet(VariantDslInfoBuilder.Companion.computeSourceSetName(((BuildType)buildType).getName(), (ComponentType)ComponentTypeImpl.ANDROID_TEST)) : null;
        DefaultAndroidSourceSet unitTestSourceSet = this.componentType.getHasTestComponents() ? (DefaultAndroidSourceSet)this.getSourceSetManager().setUpTestSourceSet(VariantDslInfoBuilder.Companion.computeSourceSetName(((BuildType)buildType).getName(), (ComponentType)ComponentTypeImpl.UNIT_TEST)) : null;
        DefaultAndroidSourceSet testFixturesSourceSet = this.componentType.getHasTestComponents() ? (DefaultAndroidSourceSet)SourceSetManager.setUpSourceSet$default(this.getSourceSetManager(), VariantDslInfoBuilder.Companion.computeSourceSetName(((BuildType)buildType).getName(), (ComponentType)ComponentTypeImpl.TEST_FIXTURES), false, 2, null) : null;
        Map<String, BuildTypeData<BuildTypeT>> map = this.getBuildTypes();
        String string = name;
        BuildTypeData<BuildTypeT> buildTypeData = new BuildTypeData<BuildTypeT>(buildType, (DefaultAndroidSourceSet)SourceSetManager.setUpSourceSet$default(this.getSourceSetManager(), ((BuildType)buildType).getName(), false, 2, null), testFixturesSourceSet, androidTestSourceSet, unitTestSourceSet);
        boolean bl = false;
        map.put(string, buildTypeData);
    }

    protected final void addProductFlavor(@NotNull ProductFlavorT productFlavor) {
        Intrinsics.checkNotNullParameter(productFlavor, (String)"productFlavor");
        String name = productFlavor.getName();
        AbstractVariantInputManager.Companion.checkName(name, "ProductFlavor");
        if (this.getBuildTypes().containsKey(name)) {
            throw new RuntimeException("ProductFlavor names cannot collide with BuildType names");
        }
        DefaultAndroidSourceSet mainSourceSet = (DefaultAndroidSourceSet)SourceSetManager.setUpSourceSet$default(this.getSourceSetManager(), productFlavor.getName(), false, 2, null);
        DefaultAndroidSourceSet testFixturesSourceSet = null;
        DefaultAndroidSourceSet androidTestSourceSet = null;
        DefaultAndroidSourceSet unitTestSourceSet = null;
        if (this.componentType.getHasTestComponents()) {
            androidTestSourceSet = (DefaultAndroidSourceSet)this.getSourceSetManager().setUpTestSourceSet(VariantDslInfoBuilder.Companion.computeSourceSetName(productFlavor.getName(), (ComponentType)ComponentTypeImpl.ANDROID_TEST));
            unitTestSourceSet = (DefaultAndroidSourceSet)this.getSourceSetManager().setUpTestSourceSet(VariantDslInfoBuilder.Companion.computeSourceSetName(productFlavor.getName(), (ComponentType)ComponentTypeImpl.UNIT_TEST));
            testFixturesSourceSet = (DefaultAndroidSourceSet)SourceSetManager.setUpSourceSet$default(this.getSourceSetManager(), VariantDslInfoBuilder.Companion.computeSourceSetName(productFlavor.getName(), (ComponentType)ComponentTypeImpl.TEST_FIXTURES), false, 2, null);
        }
        ProductFlavorData<ProductFlavorT> productFlavorData = new ProductFlavorData<ProductFlavorT>(productFlavor, mainSourceSet, testFixturesSourceSet, androidTestSourceSet, unitTestSourceSet);
        Map<String, ProductFlavorData<ProductFlavorT>> map = this.getProductFlavors();
        String string = productFlavor.getName();
        boolean bl = false;
        map.put(string, productFlavorData);
    }

    @Override
    public void lock() {
        DslContainerProvider.DefaultImpls.lock(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/variant/AbstractVariantInputManager$Companion;", "", "()V", "checkName", "", "name", "", "displayName", "checkPrefix", "prefix", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void checkName(String name, String displayName) {
            this.checkPrefix(name, displayName, "androidTest");
            this.checkPrefix(name, displayName, "test");
            if (Intrinsics.areEqual((Object)"lint", (Object)name)) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%1$s names cannot be %2$s";
                Object[] objectArray = new Object[]{displayName, "lint"};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                throw new RuntimeException(string2);
            }
        }

        private final void checkPrefix(String name, String displayName, String prefix) {
            if (StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%1$s names cannot start with '%2$s'";
                Object[] objectArray = new Object[]{displayName, prefix};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                throw new RuntimeException(string2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

