/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.lint.LintMode;
import com.android.build.gradle.internal.lint.LintTool;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.LintClassLoaderBuildService;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.AndroidXDependency;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.file.RelativePath;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class ExtractAnnotations
extends NonIncrementalTask {
    private static final AndroidXDependency ANDROIDX_ANNOTATIONS = AndroidXDependency.fromPreAndroidXDependency("com.android.support", "support-annotations");
    private FileCollection bootClasspath;
    private String encoding;
    private ArtifactCollection libraries;
    private final List<Object> sources = new ArrayList<Object>();
    private FileTree sourcesFileTree;

    @Nested
    public abstract LintTool getLintTool();

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFiles
    @IgnoreEmptyDirectories
    public FileTree getSource() {
        return this.sourcesFileTree;
    }

    @CompileClasspath
    public abstract ConfigurableFileCollection getClasspath();

    public void source(Object source) {
        this.sources.add(source);
    }

    @CompileClasspath
    public FileCollection getBootClasspath() {
        return this.bootClasspath;
    }

    public void setBootClasspath(FileCollection bootClasspath2) {
        this.bootClasspath = bootClasspath2;
    }

    @CompileClasspath
    public FileCollection getLibraries() {
        return this.libraries.getArtifactFiles();
    }

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @OutputFile
    public abstract RegularFileProperty getTypedefFile();

    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Input
    public abstract Property<String> getStrictTypedefRetention();

    @Internal
    public abstract Property<LintClassLoaderBuildService> getLintClassLoaderBuildService();

    @Override
    protected void doTaskAction() {
        ((LintClassLoaderBuildService)this.getLintClassLoaderBuildService().get()).setShouldDispose(true);
        SourceFileVisitor fileVisitor2 = new SourceFileVisitor();
        this.getSource().visit((FileVisitor)fileVisitor2);
        List sourceFiles = fileVisitor2.sourceUnits;
        if (!ExtractAnnotations.containsTypeDefs(sourceFiles)) {
            ExtractAnnotations.writeEmptyTypeDefFile(((RegularFile)this.getTypedefFile().get()).getAsFile());
            return;
        }
        ArrayList<File> classpathRoots = new ArrayList<File>();
        ConfigurableFileCollection classpath = this.getClasspath();
        if (classpath != null) {
            for (File jar : classpath) {
                classpathRoots.add(jar);
            }
        }
        classpathRoots.addAll(this.getBootClasspath().getFiles());
        ArrayList<String> args = new ArrayList<String>();
        this.addArgument(args, "--typedef-file", (Provider<? extends FileSystemLocation>)this.getTypedefFile());
        this.addArgument(args, "--output", (Provider<? extends FileSystemLocation>)this.getOutput());
        this.addArgument(args, "--sources", sourceFiles);
        this.addArgument(args, "--source-roots", fileVisitor2.sourceRoots);
        this.addArgument(args, "--classpath", classpathRoots);
        if (!Logging.getLogger(this.getClass()).isEnabled(LogLevel.INFO)) {
            args.add("--quiet");
        }
        if (((String)this.getStrictTypedefRetention().get()).equalsIgnoreCase("true")) {
            args.add("--strict-typedef-retention");
        }
        args.add("--skip-class-retention");
        args.add("--no-sort");
        this.getLintTool().submit(this.getWorkerExecutor(), "com.android.tools.lint.annotations.ExtractAnnotationsDriver", args, LintMode.EXTRACT_ANNOTATIONS);
    }

    private void addArgument(List<String> args, String name, Provider<? extends FileSystemLocation> file) {
        this.addArgument(args, name, Collections.singleton(((FileSystemLocation)file.get()).getAsFile()));
    }

    private void addArgument(List<String> args, String name, Collection<File> files2) {
        if (files2.isEmpty()) {
            return;
        }
        args.add(name);
        args.add(files2.stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
    }

    private static void writeEmptyTypeDefFile(File file) {
        if (file == null) {
            return;
        }
        try {
            FileUtils.deleteIfExists((File)file);
            Files.createParentDirs((File)file);
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean containsTypeDefs(List<File> sourceFiles) {
        for (File file : sourceFiles) {
            if (!ExtractAnnotations.containsTypeDefs(file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsTypeDefs(File file) {
        boolean bl;
        block8: {
            Stream lines = Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8).lines();
            try {
                bl = lines.anyMatch(line -> line.contains("Def") && (line.contains(SdkConstants.INT_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.INT_DEF_ANNOTATION.newName()) || line.contains(SdkConstants.LONG_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.LONG_DEF_ANNOTATION.newName()) || line.contains(SdkConstants.STRING_DEF_ANNOTATION.oldName()) || line.contains(SdkConstants.STRING_DEF_ANNOTATION.newName())));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            lines.close();
        }
        return bl;
    }

    @Input
    public boolean getHasAndroidAnnotations() {
        for (ResolvedArtifactResult artifact : this.libraries.getArtifacts()) {
            ModuleComponentIdentifier moduleId;
            ComponentIdentifier id = artifact.getId().getComponentIdentifier();
            if (!(id instanceof ModuleComponentIdentifier) || (!(moduleId = (ModuleComponentIdentifier)id).getGroup().equals(ANDROIDX_ANNOTATIONS.getGroup()) || !moduleId.getModule().equals(ANDROIDX_ANNOTATIONS.getModule())) && (!moduleId.getGroup().equals(ANDROIDX_ANNOTATIONS.getOldGroup()) || !moduleId.getModule().equals(ANDROIDX_ANNOTATIONS.getOldModule()))) continue;
            return true;
        }
        return false;
    }

    private static class SourceFileVisitor
    extends EmptyFileVisitor {
        private final List<File> sourceUnits = Lists.newArrayListWithExpectedSize((int)100);
        private final List<File> sourceRoots = Lists.newArrayList();
        private String mostRecentRoot = "\u0000";
        private static final String BUILD_GENERATED = File.separator + "build" + File.separator + "generated" + File.separator;

        public List<File> getSourceFiles() {
            return this.sourceUnits;
        }

        public List<File> getSourceRoots() {
            return this.sourceRoots;
        }

        public void visitFile(FileVisitDetails details) {
            File file = details.getFile();
            String path = file.getPath();
            if (path.endsWith(".java") && !path.contains(BUILD_GENERATED)) {
                if (!path.startsWith(this.mostRecentRoot)) {
                    String root;
                    File rootFile;
                    RelativePath relativePath = details.getRelativePath();
                    String pathString = relativePath.getPathString();
                    if (path.endsWith(pathString = pathString.replace('/', File.separatorChar)) && !this.sourceRoots.contains(rootFile = new File(root = path.substring(0, path.length() - pathString.length())))) {
                        this.mostRecentRoot = rootFile.getPath();
                        this.sourceRoots.add(rootFile);
                    }
                }
                this.sourceUnits.add(file);
            }
        }
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ExtractAnnotations, ComponentCreationConfig> {
        public CreationAction(ComponentCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("extract", "Annotations");
        }

        @Override
        public Class<ExtractAnnotations> getType() {
            return ExtractAnnotations.class;
        }

        @Override
        public void handleProvider(TaskProvider<ExtractAnnotations> taskProvider) {
            super.handleProvider(taskProvider);
            this.creationConfig.getTaskContainer().setGenerateAnnotationsTask(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, ExtractAnnotations::getOutput).withName("annotations.zip").on(InternalArtifactType.ANNOTATIONS_ZIP.INSTANCE);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, ExtractAnnotations::getTypedefFile).withName("typedefs.txt").on(InternalArtifactType.ANNOTATIONS_TYPEDEF_FILE.INSTANCE);
        }

        @Override
        public void configure(ExtractAnnotations task) {
            super.configure(task);
            task.setDescription("Extracts Android annotations for the " + this.creationConfig.getName() + " variant into the archive file");
            task.setGroup("build");
            Provider strictTypedefRetention = this.creationConfig.getServices().getGradleEnvironmentProvider().getSystemProperty("android.typedef.enforce-retention").orElse((Object)"false");
            HasConfigurableValuesKt.setDisallowChanges(task.getStrictTypedefRetention(), strictTypedefRetention);
            task.source(this.creationConfig.getSources().getJava().getAll());
            task.setEncoding(this.creationConfig.getGlobal().getCompileOptions().getEncoding());
            task.getClasspath().from(new Object[]{this.creationConfig.getCompileClasspath()}).disallowChanges();
            task.libraries = this.creationConfig.getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES_JAR);
            task.setBootClasspath((FileCollection)this.creationConfig.getServices().fileCollection(this.creationConfig.getGlobal().getFilteredBootClasspath()));
            task.getLintTool().initialize(this.creationConfig.getServices());
            task.sourcesFileTree = task.getProject().files(new Object[]{this.creationConfig.getSources().getJava().getAll()}).getAsFileTree();
            HasConfigurableValuesKt.setDisallowChanges(task.getLintClassLoaderBuildService(), BuildServicesKt.getBuildService(this.creationConfig.getServices().getBuildServiceRegistry(), LintClassLoaderBuildService.class));
        }
    }
}

