/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.DataInputOutputUtils;
import com.android.tools.mlkit.ModelVerifier;
import com.android.tools.mlkit.TensorGroupInfo;
import com.android.tools.mlkit.TensorInfo;
import com.android.tools.mlkit.TfliteModelException;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.tensorflow.lite.support.metadata.MetadataExtractor;
import org.tensorflow.lite.support.metadata.schema.ModelMetadata;
import org.tensorflow.lite.support.metadata.schema.SubGraphMetadata;

public class ModelInfo {
    private final long modelSize;
    private final String modelHash;
    private final boolean metadataExisted;
    private final boolean minParserVersionSatisfied;
    private final String modelName;
    private final String modelDescription;
    private final String modelVersion;
    private final String modelAuthor;
    private final String modelLicense;
    private final String minParserVersion;
    private final List<TensorInfo> inputs;
    private final List<TensorInfo> outputs;
    private final List<TensorGroupInfo> inputTensorGroupInfos;
    private final List<TensorGroupInfo> outputTensorGroupInfos;

    public ModelInfo(long modelSize, String modelHash, MetadataExtractor extractor) {
        ModelMetadata modelMetadata;
        this.modelSize = modelSize;
        this.modelHash = modelHash;
        ModelMetadata modelMetadata2 = modelMetadata = extractor.hasMetadata() ? extractor.getModelMetadata() : null;
        if (modelMetadata != null) {
            this.metadataExisted = true;
            this.minParserVersionSatisfied = extractor.isMinimumParserVersionSatisfied();
            this.modelName = Strings.nullToEmpty((String)modelMetadata.name());
            this.modelDescription = Strings.nullToEmpty((String)modelMetadata.description());
            this.modelVersion = Strings.nullToEmpty((String)modelMetadata.version());
            this.modelAuthor = Strings.nullToEmpty((String)modelMetadata.author());
            this.modelLicense = Strings.nullToEmpty((String)modelMetadata.license());
            this.minParserVersion = Strings.isNullOrEmpty((String)modelMetadata.minParserVersion()) ? "1.0.0" : modelMetadata.minParserVersion();
        } else {
            this.metadataExisted = false;
            this.minParserVersionSatisfied = true;
            this.modelName = "";
            this.modelDescription = "";
            this.modelVersion = "";
            this.modelAuthor = "";
            this.modelLicense = "";
            this.minParserVersion = "1.0.0";
        }
        this.inputs = new ArrayList<TensorInfo>();
        this.outputs = new ArrayList<TensorInfo>();
        this.inputTensorGroupInfos = new ArrayList<TensorGroupInfo>();
        this.outputTensorGroupInfos = new ArrayList<TensorGroupInfo>();
    }

    public ModelInfo(DataInput in) throws IOException {
        this.modelSize = in.readLong();
        this.modelHash = in.readUTF();
        this.metadataExisted = in.readBoolean();
        this.minParserVersionSatisfied = in.readBoolean();
        this.modelName = in.readUTF();
        this.modelDescription = in.readUTF();
        this.modelVersion = in.readUTF();
        this.modelAuthor = in.readUTF();
        this.modelLicense = in.readUTF();
        this.minParserVersion = in.readUTF();
        this.inputs = DataInputOutputUtils.readTensorInfoList(in);
        this.outputs = DataInputOutputUtils.readTensorInfoList(in);
        this.inputTensorGroupInfos = DataInputOutputUtils.readTensorGroupInfoList(in);
        this.outputTensorGroupInfos = DataInputOutputUtils.readTensorGroupInfoList(in);
    }

    public void save(DataOutput out) throws IOException {
        out.writeLong(this.modelSize);
        out.writeUTF(this.modelHash);
        out.writeBoolean(this.metadataExisted);
        out.writeBoolean(this.minParserVersionSatisfied);
        out.writeUTF(this.modelName);
        out.writeUTF(this.modelDescription);
        out.writeUTF(this.modelVersion);
        out.writeUTF(this.modelAuthor);
        out.writeUTF(this.modelLicense);
        out.writeUTF(this.minParserVersion);
        DataInputOutputUtils.writeTensorInfoList(out, this.inputs);
        DataInputOutputUtils.writeTensorInfoList(out, this.outputs);
        DataInputOutputUtils.writeTensorGroupInfoList(out, this.inputTensorGroupInfos);
        DataInputOutputUtils.writeTensorGroupInfoList(out, this.outputTensorGroupInfos);
    }

    public long getModelSize() {
        return this.modelSize;
    }

    public String getModelHash() {
        return this.modelHash;
    }

    public boolean isMetadataExisted() {
        return this.metadataExisted;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelDescription() {
        return this.modelDescription;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getModelAuthor() {
        return this.modelAuthor;
    }

    public String getModelLicense() {
        return this.modelLicense;
    }

    public String getMinParserVersion() {
        return this.minParserVersion;
    }

    public boolean isMinParserVersionSatisfied() {
        return this.minParserVersionSatisfied;
    }

    public List<TensorInfo> getInputs() {
        return this.inputs;
    }

    public List<TensorInfo> getOutputs() {
        return this.outputs;
    }

    public List<TensorGroupInfo> getInputTensorGroups() {
        return this.inputTensorGroupInfos;
    }

    public List<TensorGroupInfo> getOutputTensorGroups() {
        return this.outputTensorGroupInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelInfo that = (ModelInfo)o;
        return this.modelSize == that.modelSize && this.modelHash.equals(that.modelHash) && this.metadataExisted == that.metadataExisted && this.modelName.equals(that.modelName) && this.modelDescription.equals(that.modelDescription) && this.modelVersion.equals(that.modelVersion) && this.modelAuthor.equals(that.modelAuthor) && this.modelLicense.equals(that.modelLicense) && this.minParserVersion.equals(that.minParserVersion) && this.inputs.equals(that.inputs) && this.outputs.equals(that.outputs) && this.inputTensorGroupInfos.equals(that.inputTensorGroupInfos) && this.outputTensorGroupInfos.equals(that.outputTensorGroupInfos);
    }

    public int hashCode() {
        return this.modelHash.hashCode();
    }

    public static ModelInfo buildFrom(ByteBuffer byteBuffer) throws TfliteModelException {
        MetadataExtractor extractor = ModelVerifier.getExtractorWithVerification(byteBuffer);
        String modelHash = Hashing.sha256().hashBytes(byteBuffer.array()).toString();
        ModelInfo modelInfo = new ModelInfo(byteBuffer.remaining(), modelHash, extractor);
        int inputLength = extractor.getInputTensorCount();
        for (int i2 = 0; i2 < inputLength; ++i2) {
            modelInfo.inputs.add(TensorInfo.parseFrom(extractor, TensorInfo.Source.INPUT, i2));
        }
        int outputLength = extractor.getOutputTensorCount();
        for (int i3 = 0; i3 < outputLength; ++i3) {
            modelInfo.outputs.add(TensorInfo.parseFrom(extractor, TensorInfo.Source.OUTPUT, i3));
        }
        if (extractor.hasMetadata()) {
            ModelMetadata modelMetadata = extractor.getModelMetadata();
            SubGraphMetadata subGraphMetadata = modelMetadata.subgraphMetadata(0);
            int inputGroupLen = subGraphMetadata.inputTensorGroupsLength();
            for (int i4 = 0; i4 < inputGroupLen; ++i4) {
                modelInfo.inputTensorGroupInfos.add(new TensorGroupInfo(subGraphMetadata.inputTensorGroups(i4)));
            }
            int outputGroupLen = subGraphMetadata.outputTensorGroupsLength();
            for (int i5 = 0; i5 < outputGroupLen; ++i5) {
                modelInfo.outputTensorGroupInfos.add(new TensorGroupInfo(subGraphMetadata.outputTensorGroups(i5)));
            }
        }
        return modelInfo;
    }
}

