/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.CompileArtProfileTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.packaging.DexFileComparator;
import com.android.builder.packaging.DexFileNameSupplier;
import com.android.tools.profgen.ArtProfile;
import com.android.tools.profgen.ArtProfileKt;
import com.android.tools.profgen.ArtProfileSerializer;
import com.android.tools.profgen.DexDataKt;
import com.android.tools.profgen.DexFile;
import com.android.tools.profgen.Diagnostics;
import com.android.tools.profgen.HumanReadableProfile;
import com.android.tools.profgen.HumanReadableProfileKt;
import com.android.tools.profgen.ObfuscationMap;
import com.android.tools.profgen.ObfuscationMapKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.ART_PROFILE, secondaryTaskCategories={TaskCategory.COMPILATION})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/CompileArtProfileTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "binaryArtProfile", "Lorg/gradle/api/file/RegularFileProperty;", "getBinaryArtProfile", "()Lorg/gradle/api/file/RegularFileProperty;", "binaryArtProfileMetadata", "getBinaryArtProfileMetadata", "dexFolders", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDexFolders", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "featuresDexFolders", "getFeaturesDexFolders", "mergedArtProfile", "getMergedArtProfile", "obfuscationMappingFile", "getObfuscationMappingFile", "doTaskAction", "", "CompileArtProfileWorkAction", "CreationAction", "gradle-core"})
public abstract class CompileArtProfileTask
extends NonIncrementalTask {
    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getMergedArtProfile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getDexFolders();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getFeaturesDexFolders();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getObfuscationMappingFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBinaryArtProfile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getBinaryArtProfileMetadata();

    @Override
    protected void doTaskAction() {
        if (!this.getMergedArtProfile().isPresent() || !((RegularFile)this.getMergedArtProfile().get()).getAsFile().exists()) {
            return;
        }
        this.getWorkerExecutor().noIsolation().submit(CompileArtProfileWorkAction.class, new Action(this){
            final /* synthetic */ CompileArtProfileTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(CompileArtProfileWorkAction.Parameters it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getMergedArtProfile().set((Provider)this.this$0.getMergedArtProfile());
                Object[] objectArray = new Object[]{this.this$0.getDexFolders()};
                it.getDexFolders().from(objectArray);
                it.getObfuscationMappingFile().set((Provider)this.this$0.getObfuscationMappingFile());
                it.getBinaryArtProfileOutputFile().set((Provider)this.this$0.getBinaryArtProfile());
                it.getBinaryArtProfileMetadataOutputFile().set((Provider)this.this$0.getBinaryArtProfileMetadata());
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/CompileArtProfileTask$CompileArtProfileWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/CompileArtProfileTask$CompileArtProfileWorkAction$Parameters;", "()V", "run", "", "Parameters", "gradle-core"})
    public static abstract class CompileArtProfileWorkAction
    extends ProfileAwareWorkAction<Parameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            FileOutputStream it3;
            Collection<DexFile> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ObfuscationMap obfuscationMap;
            Diagnostics diagnostics2 = run.diagnostics.1.INSTANCE;
            File file = ((RegularFile)((Parameters)this.getParameters()).getMergedArtProfile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.mergedArtProfile.get().asFile");
            HumanReadableProfile humanReadableProfile = HumanReadableProfileKt.HumanReadableProfile(file, diagnostics2);
            if (humanReadableProfile == null) {
                throw new RuntimeException("Merged baseline-prof.txt cannot be parsed successfully.");
            }
            HumanReadableProfile humanReadableProfile2 = humanReadableProfile;
            DexFileNameSupplier supplier = new DexFileNameSupplier();
            if (((Parameters)this.getParameters()).getObfuscationMappingFile().isPresent()) {
                File file2 = ((RegularFile)((Parameters)this.getParameters()).getObfuscationMappingFile().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"parameters.obfuscationMappingFile.get().asFile");
                obfuscationMap = ObfuscationMapKt.ObfuscationMap(file2);
            } else {
                obfuscationMap = ObfuscationMap.Companion.getEmpty();
            }
            Set set = ((Parameters)this.getParameters()).getDexFolders().getAsFileTree().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"parameters.dexFolders.asFileTree.files");
            Object object = CollectionsKt.sortedWith((Iterable)set, (Comparator)((Comparator)new DexFileComparator()));
            ObfuscationMap obfuscationMap2 = obfuscationMap;
            HumanReadableProfile humanReadableProfile3 = humanReadableProfile2;
            boolean $i$f$map = false;
            Unit unit = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                File file3 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                InputStream inputStream = new FileInputStream((File)it2);
                String string = supplier.get();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"supplier.get()");
                collection.add(DexDataKt.DexFile(inputStream, string));
            }
            collection = (List)destination$iv$iv;
            ArtProfile artProfile = ArtProfileKt.ArtProfile$default(humanReadableProfile3, obfuscationMap2, (List)collection, null, 8, null);
            File file4 = ((RegularFile)((Parameters)this.getParameters()).getBinaryArtProfileOutputFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"parameters.binaryArtProfileOutputFile.get().asFile");
            object = file4;
            object = new FileOutputStream((File)object);
            Throwable throwable = null;
            try {
                it3 = (FileOutputStream)object;
                boolean bl = false;
                artProfile.save(it3, ArtProfileSerializer.V0_1_0_P);
                it3 = Unit.INSTANCE;
            }
            catch (Throwable it3) {
                throwable = it3;
                throw it3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            File file5 = ((RegularFile)((Parameters)this.getParameters()).getBinaryArtProfileMetadataOutputFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"parameters.binaryArtProf\u2026taOutputFile.get().asFile");
            object = file5;
            object = new FileOutputStream((File)object);
            throwable = null;
            try {
                it3 = (FileOutputStream)object;
                boolean bl = false;
                artProfile.save(it3, ArtProfileSerializer.METADATA_0_0_2);
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0012\u0010\u000f\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/CompileArtProfileTask$CompileArtProfileWorkAction$Parameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "binaryArtProfileMetadataOutputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBinaryArtProfileMetadataOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "binaryArtProfileOutputFile", "getBinaryArtProfileOutputFile", "dexFolders", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDexFolders", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "mergedArtProfile", "getMergedArtProfile", "obfuscationMappingFile", "getObfuscationMappingFile", "gradle-core"})
        public static abstract class Parameters
        extends ProfileAwareWorkAction.Parameters {
            @NotNull
            public abstract RegularFileProperty getMergedArtProfile();

            @NotNull
            public abstract ConfigurableFileCollection getDexFolders();

            @NotNull
            public abstract RegularFileProperty getObfuscationMappingFile();

            @NotNull
            public abstract RegularFileProperty getBinaryArtProfileOutputFile();

            @NotNull
            public abstract RegularFileProperty getBinaryArtProfileMetadataOutputFile();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/CompileArtProfileTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CompileArtProfileTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CompileArtProfileTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return ((ApkCreationConfig)this.creationConfig).computeTaskName("compile", "ArtProfile");
        }

        @Override
        @NotNull
        public Class<CompileArtProfileTask> getType() {
            return CompileArtProfileTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<CompileArtProfileTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).on(InternalArtifactType.BINARY_ART_PROFILE.INSTANCE);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.2.INSTANCE).on(InternalArtifactType.BINARY_ART_PROFILE_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull CompileArtProfileTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getMergedArtProfile(), ((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.MERGED_ART_PROFILE.INSTANCE));
            ConfigurableFileCollection configurableFileCollection = task.getDexFolders();
            FileCollection fileCollection2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)PackageAndroidArtifact.CreationAction.getDexFolders((ApkCreationConfig)this.creationConfig), (String)"getDexFolders(creationConfig)");
            HasConfigurableValuesKt.fromDisallowChanges(configurableFileCollection, (Object[])fileCollection2);
            fileCollection2 = PackageAndroidArtifact.CreationAction.getFeatureDexFolder((ApkCreationConfig)this.creationConfig, task.getProject().getPath());
            if (fileCollection2 != null) {
                FileCollection it = fileCollection2;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                task.getFeaturesDexFolders().from(objectArray);
            }
            task.getFeaturesDexFolders().disallowChanges();
            HasConfigurableValuesKt.setDisallowChanges((Property)task.getObfuscationMappingFile(), ((ApkCreationConfig)this.creationConfig).getArtifacts().get((SingleArtifact)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE));
        }
    }
}

