/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.features.AssetsCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.CompressAssetsDelegate;
import com.android.build.gradle.internal.tasks.CompressAssetsTask;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.TaskCategory;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.AssetsTaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.features.AssetsTaskCreationActionImpl;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.builder.packaging.PackagingUtils;
import java.io.File;
import java.util.Collection;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.gradle.workers.WorkQueue;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.APK_PACKAGING)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/CompressAssetsTask;", "Lcom/android/build/gradle/internal/tasks/NewIncrementalTask;", "()V", "compressionLevel", "Lorg/gradle/api/provider/Property;", "", "getCompressionLevel", "()Lorg/gradle/api/provider/Property;", "inputDirs", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDirs", "()Lorg/gradle/api/file/DirectoryProperty;", "noCompress", "Lorg/gradle/api/provider/ListProperty;", "", "getNoCompress", "()Lorg/gradle/api/provider/ListProperty;", "outputDir", "getOutputDir", "doTaskAction", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "CreationAction", "gradle-core"})
public abstract class CompressAssetsTask
extends NewIncrementalTask {
    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getInputDirs();

    @Input
    @NotNull
    public abstract ListProperty<String> getNoCompress();

    @Input
    @NotNull
    public abstract Property<Integer> getCompressionLevel();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Override
    public void doTaskAction(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        WorkQueue workQueue2 = this.getWorkerExecutor().noIsolation();
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"workerExecutor.noIsolation()");
        File file = ((Directory)this.getOutputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDir.get().asFile");
        Predicate predicate2 = PackagingUtils.getNoCompressPredicateForJavaRes((Collection)((Collection)this.getNoCompress().get()));
        Intrinsics.checkNotNullExpressionValue((Object)predicate2, (String)"getNoCompressPredicateForJavaRes(noCompress.get())");
        Object object = this.getCompressionLevel().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compressionLevel.get()");
        int n = ((Number)object).intValue();
        Iterable iterable = inputChanges.getFileChanges((Provider)this.getInputDirs());
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(inputDirs)");
        new CompressAssetsDelegate(workQueue2, file, predicate2, n, iterable).run();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0016\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/CompressAssetsTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CompressAssetsTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "Lcom/android/build/gradle/internal/tasks/factory/features/AssetsTaskCreationAction;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "assetsCreationConfig", "Lcom/android/build/gradle/internal/component/features/AssetsCreationConfig;", "getAssetsCreationConfig", "()Lcom/android/build/gradle/internal/component/features/AssetsCreationConfig;", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CompressAssetsTask, ApkCreationConfig>
    implements AssetsTaskCreationAction {
        private final /* synthetic */ AssetsTaskCreationActionImpl $$delegate_0;

        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
            this.$$delegate_0 = new AssetsTaskCreationActionImpl(creationConfig);
        }

        @Override
        @NotNull
        public AssetsCreationConfig getAssetsCreationConfig() {
            return this.$$delegate_0.getAssetsCreationConfig();
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("compress", "Assets");
        }

        @Override
        @NotNull
        public Class<CompressAssetsTask> getType() {
            return CompressAssetsTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<CompressAssetsTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("out").on(InternalArtifactType.COMPRESSED_ASSETS.INSTANCE);
        }

        @Override
        public void configure(@NotNull CompressAssetsTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getInputDirs().set(((ApkCreationConfig)this.creationConfig).getArtifacts().get((SingleArtifact)SingleArtifact.ASSETS.INSTANCE));
            HasConfigurableValuesKt.setDisallowChanges(task.getNoCompress(), (Provider)this.getAssetsCreationConfig().getAndroidResources().getNoCompress());
            HasConfigurableValuesKt.setDisallowChanges(task.getCompressionLevel(), ((ApkCreationConfig)this.creationConfig).getDebuggable() ? 1 : -1);
        }
    }
}

