/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.gradle.internal.testing.BaseTestRunner;
import com.android.build.gradle.internal.testing.ShardedTestRunnable;
import com.android.build.gradle.internal.testing.StaticTestData;
import com.android.builder.testing.api.DeviceConnector;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ShardedTestRunner
extends BaseTestRunner {
    private final Integer numShards;

    public ShardedTestRunner(File splitSelectExec, ProcessExecutor processExecutor2, Integer numShards, ExecutorServiceAdapter executor2) {
        super(splitSelectExec, processExecutor2, executor2);
        this.numShards = numShards;
    }

    @Override
    protected List<BaseTestRunner.TestResult> scheduleTests(String projectName, String variantName, StaticTestData testData, Map<DeviceConnector, ImmutableList<File>> apksForDevice, Set<File> helperApks, int timeoutInMs, Collection<String> installOptions, File resultsDir, boolean additionalTestOutputEnabled, File additionalTestOutputDir, File coverageDir, ILogger logger) {
        final int numShards = this.numShards == null ? apksForDevice.size() : this.numShards.intValue();
        final AtomicInteger currentShard = new AtomicInteger(-1);
        ShardedTestRunnable.ProgressListener progressListener = new ShardedTestRunnable.ProgressListener(numShards, logger);
        ShardedTestRunnable.ShardProvider shardProvider = new ShardedTestRunnable.ShardProvider(){

            @Override
            public Integer getNextShard() {
                int shard = currentShard.incrementAndGet();
                return shard < numShards ? Integer.valueOf(shard) : null;
            }

            @Override
            public int getTotalShards() {
                return numShards;
            }
        };
        logger.lifecycle("will shard tests into %d shards", new Object[]{numShards});
        ArrayList<BaseTestRunner.TestResult> results = new ArrayList<BaseTestRunner.TestResult>();
        for (Map.Entry<DeviceConnector, ImmutableList<File>> runners : apksForDevice.entrySet()) {
            BaseTestRunner.TestResult result2 = new BaseTestRunner.TestResult();
            results.add(result2);
            ShardedTestRunnable.ShardedTestParams shardedTestParams = new ShardedTestRunnable.ShardedTestParams(runners.getKey(), projectName, variantName, (List)runners.getValue(), testData, resultsDir, coverageDir, timeoutInMs, logger, shardProvider, progressListener, result2);
            this.executor.submit((WorkerExecutorFacade.WorkAction)new ShardedTestRunnable(shardedTestParams));
        }
        return results;
    }
}

