/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.prefab;

import com.android.build.api.dsl.PrefabPackagingOptions;
import com.android.build.gradle.internal.component.LibraryCreationConfig;
import com.android.build.gradle.internal.cxx.configure.ExperimentalPropertyExtensionsKt;
import com.android.build.gradle.internal.cxx.configure.PrefabExperimentalPackagingOptions;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.prefab.PrefabAbiPublication;
import com.android.build.gradle.internal.cxx.prefab.PrefabModulePublication;
import com.android.build.gradle.internal.cxx.prefab.PrefabPackagePublication;
import com.android.build.gradle.internal.cxx.prefab.PrefabPublication;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"EXTRACT_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createPrefabPublication", "Lcom/android/build/gradle/internal/cxx/prefab/PrefabPublication;", "configurationModel", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxConfigurationModel;", "libraryVariant", "Lcom/android/build/gradle/internal/component/LibraryCreationConfig;", "gradleVersionToPrefabPackageVersion", "", "version", "gradle-core"})
public final class CreatePublicationModelKt {
    private static final Pattern EXTRACT_VERSION_PATTERN = Pattern.compile("^\\d+(\\.\\d+(\\.\\d+(\\.\\d+)?)?)?");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PrefabPublication createPrefabPublication(@NotNull CxxConfigurationModel configurationModel, @NotNull LibraryCreationConfig libraryVariant) {
        void $this$mapTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)configurationModel, (String)"configurationModel");
        Intrinsics.checkNotNullParameter((Object)libraryVariant, (String)"libraryVariant");
        Iterable $this$map$iv = configurationModel.getActiveAbis();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void abi;
            CxxAbiModel cxxAbiModel = (CxxAbiModel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = abi.getAbi().getTag();
            int n = CxxAbiModelKt.getMinSdkVersion((CxxAbiModel)abi);
            string = abi.getVariant().getStlType();
            int n2 = abi.getVariant().getModule().getNdkVersion().getMajor();
            File file = CxxAbiModelKt.getJsonFile((CxxAbiModel)abi).getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"absoluteFile");
            collection.add(new PrefabAbiPublication(string2, n, n2, string, null, file));
        }
        List abis2 = (List)destination$iv$iv;
        Iterable $this$map$iv2 = libraryVariant.getGlobal().getPrefab();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list;
            File file;
            File file2;
            void options;
            PrefabPackagingOptions bl = (PrefabPackagingOptions)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            PrefabExperimentalPackagingOptions experimentalSettings = ExperimentalPropertyExtensionsKt.getPrefabExperimentalPackagingOptions(libraryVariant, options.getName());
            string = options.getName();
            String string3 = options.getLibraryName();
            if (options.getHeaders() != null) {
                String headers;
                boolean bl3 = false;
                file2 = libraryVariant.getServices().getProjectInfo().getProjectDirectory().dir(headers).getAsFile().getAbsoluteFile();
            } else {
                file2 = file = null;
            }
            if ((list = experimentalSettings.getExportLibraries()) == null) {
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            collection.add(new PrefabModulePublication(string, file, list2, string3, abis2));
        }
        List modules = (List)destination$iv$iv2;
        File file = FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)libraryVariant.getServices().getProjectInfo().getIntermediatesDir(), (String)"prefab_package"), (String)libraryVariant.getName()), (String)"prefab").getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"libraryVariant.services.\u2026ve(\"prefab\").absoluteFile");
        return new PrefabPublication(file, configurationModel.getVariant().getModule().getGradleModulePathName(), new PrefabPackagePublication(libraryVariant.getServices().getProjectInfo().getName(), CreatePublicationModelKt.gradleVersionToPrefabPackageVersion(libraryVariant.getServices().getProjectInfo().getVersion()), 2, CollectionsKt.emptyList(), modules));
    }

    private static final String gradleVersionToPrefabPackageVersion(String version) {
        String string;
        Matcher m = EXTRACT_VERSION_PATTERN.matcher(version);
        if (m.find()) {
            string = m.group();
        } else if (Intrinsics.areEqual((Object)version, (Object)"unspecified")) {
            string = null;
        } else {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.PREFAB_GRADLE_VERSION_NOT_COMPATIBLE_WITH_PREFAB, "The package version '" + version + "' is incompatible with Prefab", new Object[0]);
            string = version;
        }
        return string;
    }
}

