/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.level2;

import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class SimpleDependencyGraphsImpl
implements DependencyGraphs,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<GraphItem> items;
    private final List<String> providedLibraries;
    private final int hashCode;

    public SimpleDependencyGraphsImpl(List<GraphItem> items, List<String> providedLibraries) {
        this.items = items;
        this.providedLibraries = ImmutableList.copyOf(providedLibraries);
        this.hashCode = this.computeHashCode();
    }

    public List<GraphItem> getCompileDependencies() {
        return this.items;
    }

    public List<GraphItem> getPackageDependencies() {
        return Collections.emptyList();
    }

    public List<String> getProvidedLibraries() {
        return this.providedLibraries;
    }

    public List<String> getSkippedLibraries() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDependencyGraphsImpl that = (SimpleDependencyGraphsImpl)o;
        return this.items.equals(that.items) && this.providedLibraries.equals(that.providedLibraries);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result2 = this.items.hashCode();
        result2 = 31 * result2 + this.providedLibraries.hashCode();
        return result2;
    }
}

