/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.testing.AdbHelper;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ8\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000bJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J.\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010 \u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\"\u0010$\u001a\u00020\u0019*\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190&H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "", "showEmulatorKernelLogging", "", "deviceBootAndSnapshotCheckTimeoutSec", "", "adbHelper", "Lcom/android/build/gradle/internal/testing/AdbHelper;", "processFactory", "Lkotlin/Function1;", "", "", "Ljava/lang/ProcessBuilder;", "(ZLjava/lang/Long;Lcom/android/build/gradle/internal/testing/AdbHelper;Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Long;", "checkSnapshotLoadable", "avdName", "emulatorExecutable", "Ljava/io/File;", "avdLocation", "emulatorGpuFlag", "logger", "Lcom/android/utils/ILogger;", "snapshotName", "closeEmulatorWithId", "", "emulatorProcess", "Ljava/lang/Process;", "idValue", "ensureEmulatorVersionRequirement", "emulatorDir", "generateSnapshot", "getEmulatorExecutable", "emulatorDirectoryProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "waitUntilTimeout", "onTimeout", "Lkotlin/Function0;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAvdSnapshotHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdSnapshotHandler.kt\ncom/android/build/gradle/internal/AvdSnapshotHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
public final class AvdSnapshotHandler {
    private final boolean showEmulatorKernelLogging;
    @Nullable
    private final Long deviceBootAndSnapshotCheckTimeoutSec;
    @NotNull
    private final AdbHelper adbHelper;
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processFactory;

    public AvdSnapshotHandler(boolean showEmulatorKernelLogging, @Nullable Long deviceBootAndSnapshotCheckTimeoutSec, @NotNull AdbHelper adbHelper, @NotNull Function1<? super List<String>, ProcessBuilder> processFactory) {
        Intrinsics.checkNotNullParameter((Object)adbHelper, (String)"adbHelper");
        Intrinsics.checkNotNullParameter(processFactory, (String)"processFactory");
        this.showEmulatorKernelLogging = showEmulatorKernelLogging;
        this.deviceBootAndSnapshotCheckTimeoutSec = deviceBootAndSnapshotCheckTimeoutSec;
        this.adbHelper = adbHelper;
        this.processFactory = processFactory;
    }

    public /* synthetic */ AvdSnapshotHandler(boolean bl, Long l, AdbHelper adbHelper, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = 1.INSTANCE;
        }
        this(bl, l, adbHelper, (Function1<? super List<String>, ProcessBuilder>)function1);
    }

    @NotNull
    public final File getEmulatorExecutable(@NotNull Provider<Directory> emulatorDirectoryProvider2) {
        Intrinsics.checkNotNullParameter(emulatorDirectoryProvider2, (String)"emulatorDirectoryProvider");
        Directory directory2 = (Directory)emulatorDirectoryProvider2.getOrNull();
        File file = directory2 != null ? directory2.getAsFile() : null;
        if (file == null) {
            throw new IllegalStateException("Emulator dir does not exist".toString());
        }
        File emulatorDir = file;
        this.ensureEmulatorVersionRequirement(emulatorDir);
        return FilesKt.resolve((File)emulatorDir, (String)"emulator");
    }

    public final boolean checkSnapshotLoadable(@NotNull String avdName, @NotNull File emulatorExecutable, @NotNull File avdLocation, @NotNull String emulatorGpuFlag, @NotNull ILogger logger, @NotNull String snapshotName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)emulatorExecutable, (String)"emulatorExecutable");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)snapshotName, (String)"snapshotName");
        logger.info("Checking " + snapshotName + " on device " + avdName + " is loadable.", new Object[0]);
        Object object = new String[11];
        object[0] = emulatorExecutable.getAbsolutePath();
        object[1] = "@" + avdName;
        object[2] = "-no-window";
        object[3] = "-no-boot-anim";
        object[4] = "-no-audio";
        String string2 = string = "-verbose";
        int n = 5;
        Object[] objectArray = object;
        Function1<List<String>, ProcessBuilder> function1 = this.processFactory;
        boolean bl = false;
        boolean bl2 = this.showEmulatorKernelLogging;
        objectArray[n] = bl2 ? string : null;
        String it = string = "-show-kernel";
        n = 6;
        objectArray = object;
        boolean bl3 = false;
        bl2 = this.showEmulatorKernelLogging;
        objectArray[n] = bl2 ? string : null;
        object[7] = "-gpu";
        object[8] = emulatorGpuFlag;
        object[9] = "-check-snapshot-loadable";
        object[10] = snapshotName;
        ProcessBuilder processBuilder = (ProcessBuilder)function1.invoke((Object)CollectionsKt.listOfNotNull((Object[])object));
        Map<String, String> map = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"processBuilder.environment()");
        object = map;
        string = "ANDROID_AVD_HOME";
        it = avdLocation.getAbsolutePath();
        object.put(string, it);
        Process process2 = processBuilder.start();
        Ref.BooleanRef success2 = new Ref.BooleanRef();
        try {
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(logger, success2){
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ Ref.BooleanRef $success;
                {
                    this.$logger = $logger;
                    this.$success = $success;
                }

                public void out(@Nullable String line) {
                    if (line == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Loadable", (boolean)false, (int)2, null)) {
                        this.$success.element = true;
                    }
                }

                public void err(@Nullable String line) {
                }
            });
        }
        catch (Exception e) {
            process2.destroy();
            throw new RuntimeException(e);
        }
        return success2.element;
    }

    public static /* synthetic */ boolean checkSnapshotLoadable$default(AvdSnapshotHandler avdSnapshotHandler, String string, File file, File file2, String string2, ILogger iLogger, String string3, int n, Object object) {
        if ((n & 0x20) != 0) {
            string3 = "default_boot";
        }
        return avdSnapshotHandler.checkSnapshotLoadable(string, file, file2, string2, iLogger, string3);
    }

    private final void waitUntilTimeout(Process $this$waitUntilTimeout, ILogger logger, Function0<Unit> onTimeout) {
        long timeoutSec;
        Long l = this.deviceBootAndSnapshotCheckTimeoutSec;
        long l2 = timeoutSec = l != null ? l : 600L;
        if (timeoutSec > 0L) {
            logger.verbose("Waiting for a process to complete (timeout " + timeoutSec + " seconds)", new Object[0]);
            if (!$this$waitUntilTimeout.waitFor(timeoutSec, TimeUnit.SECONDS)) {
                onTimeout.invoke();
            }
        } else {
            logger.verbose("Waiting for a process to complete (no timeout)", new Object[0]);
            $this$waitUntilTimeout.waitFor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateSnapshot(@NotNull String avdName, @NotNull File emulatorExecutable, @NotNull File avdLocation, @NotNull String emulatorGpuFlag, @NotNull ILogger logger) {
        String string;
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)emulatorExecutable, (String)"emulatorExecutable");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.verbose("Creating snapshot for " + avdName, new Object[0]);
        String deviceId = avdName + "_snapshot";
        Object object = new String[11];
        object[0] = emulatorExecutable.getAbsolutePath();
        object[1] = "@" + avdName;
        object[2] = "-no-window";
        object[3] = "-no-boot-anim";
        object[4] = "-no-audio";
        String string2 = string = "-verbose";
        int n = 5;
        Object[] objectArray = object;
        Function1<List<String>, ProcessBuilder> function1 = this.processFactory;
        boolean bl = false;
        boolean bl2 = this.showEmulatorKernelLogging;
        objectArray[n] = bl2 ? string : null;
        String it = string = "-show-kernel";
        n = 6;
        objectArray = object;
        boolean bl3 = false;
        bl2 = this.showEmulatorKernelLogging;
        objectArray[n] = bl2 ? string : null;
        object[7] = "-id";
        object[8] = deviceId;
        object[9] = "-gpu";
        object[10] = emulatorGpuFlag;
        ProcessBuilder processBuilder = (ProcessBuilder)function1.invoke((Object)CollectionsKt.listOfNotNull((Object[])object));
        Map<String, String> map = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"processBuilder.environment()");
        object = map;
        string = "ANDROID_AVD_HOME";
        string2 = avdLocation.getAbsolutePath();
        object.put(string, string2);
        Process process2 = processBuilder.start();
        AtomicBoolean bootCompleted = new AtomicBoolean(false);
        try {
            new Thread(new Runnable(process2, this, deviceId, logger, avdName, bootCompleted){
                final /* synthetic */ Process $process;
                final /* synthetic */ AvdSnapshotHandler this$0;
                final /* synthetic */ String $deviceId;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ String $avdName;
                final /* synthetic */ AtomicBoolean $bootCompleted;
                {
                    this.$process = $process;
                    this.this$0 = $receiver;
                    this.$deviceId = $deviceId;
                    this.$logger = $logger;
                    this.$avdName = $avdName;
                    this.$bootCompleted = $bootCompleted;
                }

                public final void run() {
                    String emulatorSerial = null;
                    while (this.$process.isAlive()) {
                        try {
                            emulatorSerial = AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).findDeviceSerialWithId(this.$deviceId, this.$logger);
                            break;
                        }
                        catch (Exception e) {
                            this.$logger.verbose("Waiting for " + this.$avdName + " to be attached to adb.", new Object[0]);
                            Thread.sleep(5000L);
                        }
                    }
                    if (emulatorSerial == null) {
                        return;
                    }
                    this.$logger.verbose(this.$avdName + " is attached to adb (" + emulatorSerial + ").", new Object[0]);
                    while (this.$process.isAlive() && !AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).isBootCompleted(emulatorSerial, this.$logger)) {
                        this.$logger.verbose("Waiting for " + this.$avdName + " to boot up.", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("Booting " + this.$avdName + " is completed.", new Object[0]);
                    while (this.$process.isAlive() && !AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).isPackageManagerStarted(emulatorSerial)) {
                        this.$logger.verbose("Waiting for PackageManager to be ready on " + this.$avdName + ".", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("PackageManager is ready on " + this.$avdName + ".", new Object[0]);
                    if (this.$process.isAlive()) {
                        this.$bootCompleted.set(true);
                        Thread.sleep(5000L);
                        AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).killDevice(emulatorSerial);
                    }
                }
            }).start();
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(logger){
                final /* synthetic */ ILogger $logger;
                {
                    this.$logger = $logger;
                }

                public void out(@Nullable String line) {
                    if (line == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                }

                public void err(@Nullable String line) {
                    if (line == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            this.waitUntilTimeout(process2, logger, (Function0<Unit>)((Function0)new Function0<Unit>(logger, this, process2, deviceId, avdName){
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ AvdSnapshotHandler this$0;
                final /* synthetic */ Process $process;
                final /* synthetic */ String $deviceId;
                final /* synthetic */ String $avdName;
                {
                    this.$logger = $logger;
                    this.this$0 = $receiver;
                    this.$process = $process;
                    this.$deviceId = $deviceId;
                    this.$avdName = $avdName;
                    super(0);
                }

                public final void invoke() {
                    this.$logger.verbose("Snapshot creation timed out. Closing emulator.", new Object[0]);
                    Process process2 = this.$process;
                    Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
                    AvdSnapshotHandler.access$closeEmulatorWithId(this.this$0, process2, this.$deviceId, this.$logger);
                    this.$process.waitFor();
                    throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    Gradle was not able to complete device setup for: " + this.$avdName + "\n                    This could be due to having insufficient resources to provision the number of\n                    devices requested. Try running the test again and request fewer devices or\n                    fewer shards.\n                ")).toString());
                }
            }));
            if (!bootCompleted.get()) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    Gradle was not able to complete device setup for: " + avdName + "\n                    The emulator failed to open the managed device to generate the snapshot.\n                    This is because the emulator closed unexpectedly, try updating the emulator and\n                    ensure a device can be run from Android Studio.\n                ")).toString());
            }
            logger.info("Successfully created snapshot for: " + avdName, new Object[0]);
            this.closeEmulatorWithId(process2, deviceId, logger);
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            this.closeEmulatorWithId(process2, deviceId, logger);
            process2.waitFor();
            throw throwable;
        }
        process2.waitFor();
    }

    private final void closeEmulatorWithId(Process emulatorProcess, String idValue, ILogger logger) {
        try {
            String emulatorSerial = this.adbHelper.findDeviceSerialWithId(idValue, logger);
            this.adbHelper.killDevice(emulatorSerial);
        }
        catch (Exception e) {
            logger.info("Failed to close emulator properly from adb. Reason: " + e, new Object[0]);
            emulatorProcess.destroy();
        }
    }

    private final void ensureEmulatorVersionRequirement(File emulatorDir) {
        File packageFile = FilesKt.resolve((File)emulatorDir, (String)"package.xml");
        Pattern versionPattern = Pattern.compile("<major>(\\d+)</major><minor>(\\d+)</minor><micro>(\\d+)</micro>");
        for (String line : Files.readAllLines(packageFile.toPath())) {
            Matcher matcher = versionPattern.matcher(line);
            if (!matcher.find()) continue;
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
            int majorVersion = Integer.parseInt(string);
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(2)");
            int minorVersion = Integer.parseInt(string2);
            String string3 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(3)");
            int microVersion = Integer.parseInt(string3);
            if (majorVersion > 30) {
                return;
            }
            if (majorVersion == 30 && minorVersion > 6) {
                return;
            }
            if (majorVersion == 30 && minorVersion == 6 && microVersion >= 4) {
                return;
            }
            throw new IllegalStateException(("Emulator needs to be updated in order to use managed devices. Minimum version required: 30.6.4. Version found: " + majorVersion + "." + minorVersion + "." + microVersion + ".").toString());
        }
        throw new IllegalStateException(("Could not determine version of Emulator in " + emulatorDir.getAbsolutePath() + ". Update emulator in order to use Managed Devices.").toString());
    }

    public static final /* synthetic */ AdbHelper access$getAdbHelper$p(AvdSnapshotHandler $this) {
        return $this.adbHelper;
    }

    public static final /* synthetic */ void access$closeEmulatorWithId(AvdSnapshotHandler $this, Process emulatorProcess, String idValue, ILogger logger) {
        $this.closeEmulatorWithId(emulatorProcess, idValue, logger);
    }
}

