/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.ninja;

import com.android.build.gradle.internal.cxx.ninja.NinjaBuildDepsCodecKt;
import com.android.build.gradle.internal.cxx.ninja.Record;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/cxx/ninja/NinjaDepsDecoder;", "", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "schemaVersion", "", "sizeOfTimestamp", "read", "Lcom/android/build/gradle/internal/cxx/ninja/Record;", "readHeader", "Lcom/android/build/gradle/internal/cxx/ninja/Record$Version;", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNinjaBuildDepsCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NinjaBuildDepsCodec.kt\ncom/android/build/gradle/internal/cxx/ninja/NinjaDepsDecoder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,373:1\n13586#2,2:374\n*S KotlinDebug\n*F\n+ 1 NinjaBuildDepsCodec.kt\ncom/android/build/gradle/internal/cxx/ninja/NinjaDepsDecoder\n*L\n220#1:374,2\n*E\n"})
final class NinjaDepsDecoder {
    @NotNull
    private final ByteBuffer buffer;
    private int schemaVersion;
    private int sizeOfTimestamp;

    public NinjaDepsDecoder(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    private final Record.Version readHeader() {
        byte[] $this$forEach$iv = NinjaBuildDepsCodecKt.access$getMAGIC$p();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            byte element$iv;
            byte expected = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            byte actual = this.buffer.get();
            if (actual == expected) continue;
            throw new IllegalStateException("Was not a .ninja_deps file".toString());
        }
        this.schemaVersion = this.buffer.getInt();
        Preconditions.checkArgument((this.schemaVersion == 3 || this.schemaVersion == 4 ? 1 : 0) != 0);
        this.sizeOfTimestamp = this.schemaVersion == 3 ? 4 : 8;
        return new Record.Version(this.schemaVersion);
    }

    @NotNull
    public final Record read() {
        long provisional;
        if (this.buffer.position() == 0) {
            return this.readHeader();
        }
        if (this.buffer.position() == this.buffer.capacity()) {
            return Record.EOF.INSTANCE;
        }
        int typeAndSize = this.buffer.getInt();
        int start = this.buffer.position();
        if (typeAndSize > 0) {
            int len;
            ByteBuffer view = this.buffer.slice();
            for (len = 0; this.buffer.get() != 0 && len < typeAndSize - 4; ++len) {
            }
            view.limit(len);
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(view);
            Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"UTF_8.decode(view)");
            CharBuffer charBuffer2 = charBuffer;
            this.buffer.position(start + typeAndSize - 4);
            int checksum = this.buffer.getInt();
            return new Record.Path(charBuffer2, checksum);
        }
        int size = typeAndSize - Integer.MIN_VALUE;
        int targetPath = this.buffer.getInt();
        long l = provisional = this.schemaVersion == 3 ? (long)this.buffer.getInt() : this.buffer.getLong();
        Long timestamp = provisional == 0L ? null : (provisional == 1L ? Long.valueOf(0L) : Long.valueOf(provisional));
        int pathsSize = size - 4 - this.sizeOfTimestamp;
        ByteBuffer view = this.buffer.slice();
        view.limit(pathsSize);
        view.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.position(start + size);
        IntBuffer intBuffer = view.asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"view.asIntBuffer()");
        return new Record.Dependencies(targetPath, timestamp, intBuffer);
    }
}

