/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.lint.LintFromMaven;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.services.DslServicesImpl;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.utils.FileUtils;
import java.io.File;
import kotlin.jvm.functions.Function1;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;

class ReportingPlugin
implements Plugin<Project> {
    private TestOptions extension;

    public void apply(Project project) {
        project.evaluationDependsOnChildren();
        ProjectOptions projectOptions = ((ProjectOptionService)new ProjectOptionService.RegistrationAction(project).execute().get()).getProjectOptions();
        SyncIssueReporterImpl syncIssueHandler = new SyncIssueReporterImpl(SyncOptions.getModelQueryMode(projectOptions), SyncOptions.getErrorFormatMode(projectOptions), project.getLogger());
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(syncIssueHandler, projectOptions, project.getPath());
        LintFromMaven lintFromMaven = LintFromMaven.from(project, projectOptions, syncIssueHandler);
        ProjectServices projectServices2 = new ProjectServices(syncIssueHandler, deprecationReporter, project.getObjects(), project.getLogger(), project.getProviders(), project.getLayout(), projectOptions, project.getGradle().getSharedServices(), lintFromMaven, null, null, project.getGradle().getStartParameter().getMaxWorkerCount(), new ProjectInfo(project), (Function1<Object, ? extends File>)((Function1)arg_0 -> ((Project)project).file(arg_0)), project.getConfigurations(), project.getDependencies(), project.getExtensions().getExtraProperties(), arg_0 -> ((TaskContainer)project.getTasks()).register(arg_0));
        DslServicesImpl dslServices2 = new DslServicesImpl(projectServices2, (Provider<SdkComponentsBuildService>)project.getProviders().provider(() -> null), null, null);
        this.extension = (TestOptions)project.getExtensions().create("android", TestOptions.class, new Object[]{dslServices2});
        AndroidReportTask mergeReportsTask = (AndroidReportTask)project.getTasks().create("mergeAndroidReports", AndroidReportTask.class);
        mergeReportsTask.setGroup("verification");
        mergeReportsTask.setDescription("Merges all the Android test reports from the sub projects.");
        mergeReportsTask.setReportType(ReportType.MULTI_PROJECT);
        mergeReportsTask.getResultsDir().set(project.provider(() -> {
            String resultsDir = this.extension.getResultsDir();
            if (resultsDir == null) {
                return (Directory)project.getLayout().getBuildDirectory().dir("androidTest-results").get();
            }
            return project.getLayout().getProjectDirectory().dir(resultsDir);
        }));
        mergeReportsTask.getReportsDir().set(project.provider(() -> {
            String reportsDir = this.extension.getReportDir();
            if (reportsDir == null) {
                return (Directory)project.getLayout().getBuildDirectory().dir(FileUtils.join((String[])new String[]{"reports", "androidTests"})).get();
            }
            return project.getLayout().getProjectDirectory().dir(reportsDir);
        }));
        project.afterEvaluate(prj -> {
            for (Project p : prj.getSubprojects()) {
                TaskCollection tasks = p.getTasks().withType(AndroidReportTask.class);
                for (AndroidReportTask task : tasks) {
                    mergeReportsTask.addTask(task);
                }
                TaskCollection tasks2 = p.getTasks().withType(DeviceProviderInstrumentTestTask.class);
                for (DeviceProviderInstrumentTestTask task : tasks2) {
                    mergeReportsTask.addTask(task);
                }
            }
        });
        if (project.getGradle().getStartParameter().isContinueOnFailure()) {
            project.getGradle().getTaskGraph().whenReady(taskExecutionGraph -> {
                if (taskExecutionGraph.hasTask((Task)mergeReportsTask)) {
                    mergeReportsTask.setWillRun();
                }
            });
        }
    }
}

